---
name: moltbot-plugin-2do
description: "Create tasks and send them to 2Do app via email. Use when the user wants to: (1) add, create, or record a task/todo/reminder in any form - e.g. '添加任务', '创建待办', '新建任务', '加个任务', '记录任务', 'add task', 'create todo'; (2) ask to be reminded of something - e.g. '提醒我', '别忘了', '记得', '帮我记一下', 'remind me', 'remember to'; (3) mention something they need to do and want it tracked - e.g. '明天要开会', '周五前交报告', '下午去买菜'; (4) want to add items to a todo list or task manager - e.g. '加到待办', '放到任务列表', '记到清单里'; (5) describe a task with list/tag organization - e.g. '添加到工作列表', '标签是紧急'; (6) mention urgency or importance - e.g. '紧急', '重要', 'urgent', 'important'. Parses natural language (Chinese and English) to extract task title, due date/time, priority, optional list name, and optional tags, then sends a formatted email to the user's configured 2Do inbox."
metadata:
  {"openclaw": {"emoji": "✅", "requires": {"env": ["TWODO_EMAIL", "SMTP_HOST", "SMTP_PORT", "SMTP_USER", "SMTP_PASS"], "bins": ["node"]}}}
---

# 2Do Task Email

Create tasks from natural language and send them to 2Do app via email. Supports both Chinese and English input.

## Execution

### Natural language mode (recommended)

Pass the user's raw message. The script parses task title, due date, priority, list, and tags automatically:

```bash
bash {baseDir}/scripts/send-task.sh --raw "USER_MESSAGE_HERE"
```

### Structured mode

When task components are already extracted:

```bash
bash {baseDir}/scripts/send-task.sh --title "TITLE" --list "LIST_NAME" --tags "TAG1,TAG2"
```

## Parameters

| Parameter | Description | Required |
|-----------|-------------|----------|
| `--raw` | Raw natural language input, auto-parsed | Either --raw or --title |
| `--title` | Task title | Either --raw or --title |
| `--list` | Target list name | No |
| `--tags` | Tags, comma-separated | No |

## Natural Language Patterns

### Task prefixes

Chinese: "添加任务：", "创建待办：", "提醒我：", "记录任务：", "新建任务：", "加个任务："

English: "add task:", "create todo:", "remind me to", "remember to"

No-prefix input is also supported — the entire input becomes the task title.

### Date/time extraction

Relative dates: 今天, 明天, 后天, 大后天

Week days: 周一~周日, 下周一~下周日, 星期X

Specific dates: X月X日/号

Time: 上午/下午/晚上 X点 X分/半

Extracted dates are automatically converted to 2Do's `start()` and `due()` format in the email subject for proper task scheduling.

### List and tag assignment

Chinese: "列表是X", "到X列表", "标签是X和Y"

English: ", list X", ", tag X and Y"

### Priority

Chinese: 紧急(high), 重要(medium), 不急(low)

English: urgent(high), important(medium), low priority(low)

## Output

Success: `✅ 任务已发送到 2Do: {task title}`

Failure: error message with non-zero exit code.

## Configuration

Required environment variables:

- `TWODO_EMAIL` - Recipient email address configured in 2Do
- `SMTP_HOST` - SMTP server (e.g. smtp.gmail.com)
- `SMTP_PORT` - SMTP port (587 for STARTTLS, 465 for SSL)
- `SMTP_USER` - SMTP username
- `SMTP_PASS` - SMTP password (app-specific password recommended)

Optional:

- `TITLE_PREFIX` - Email subject prefix for matching 2Do capture rules (e.g. "2Do:")
