# moltbot-plugin-2do

一个 [Moltbot (OpenClaw)](https://docs.openclaw.ai) 插件，通过自然语言创建任务并发送到 [2Do](https://www.2doapp.com) app。

支持所有 Moltbot 消息渠道（QQ、企业微信、Slack、Telegram、WhatsApp、Discord 等），利用 2Do 的 [Email to 2Do](https://www.2doapp.com/kb/category/ios/email-to-2do/44/) 功能自动捕获邮件为任务。

## 功能

- 自然语言意图识别 — 无需固定命令前缀，自然表达即可触发
- 中英文双语解析（中文 + 英文命令前缀）
- 日期/时间提取（明天、下周五、下午3点等）
- 自动设置 2Do 开始时间和截止时间（通过 `start()`/`due()` 格式）
- 优先级识别（紧急/重要/urgent/important）
- 支持指定目标列表和标签
- 支持邮件标题前缀配置（用于精确匹配 2Do 捕获规则）
- 通过 SMTP 邮件发送到 2Do
- 支持所有 Moltbot 消息渠道

## 使用示例

**基本任务：**

> 添加任务：买牛奶

**自然表达（无需固定前缀）：**

> 帮我记一下明天下午3点开会

> 别忘了周五交报告

**英文命令：**

> add task: buy groceries

> remind me to call John tomorrow

**日期/时间（自动设置 2Do 开始/截止时间）：**

> 添加任务：明天下午3点开会

> 添加任务：下周五前提交报告

> 创建待办：3月15号出发

**优先级：**

> 添加任务：修复线上 bug，紧急

> add task: fix production issue, urgent

**指定列表：**

> 添加任务到工作列表：完成项目报告

> add task to shopping list: buy fruits

**指定标签：**

> 添加任务：买菜，标签是家务和购物

> add task: deploy, tag backend and devops

**完整组合：**

> 添加任务：明天完成季度报告，列表是工作，标签是紧急和财务

## 安装与更新

### 前置条件

- Node.js >= 22
- Moltbot (OpenClaw) 已安装
- 2Do app 已配置 Email to 2Do 功能
- 可用的 SMTP 邮箱账户

### 方式一：通过 ClawHub 安装（推荐）

访问 ClawHub 插件页面安装或更新：

[https://clawhub.ai/chuckiefan/moltbot-plugin-2do](https://clawhub.ai/chuckiefan/moltbot-plugin-2do)

按页面提示完成安装即可。后续更新也可通过 ClawHub 页面进行。

### 方式二：通过 Git 手动安装

将项目克隆到 Moltbot 的 skills 目录：

**从 GitHub 安装：**

```bash
cd ~/.openclaw/skills
git clone https://github.com/chuckiefan/moltbot-plugin-2do.git
cd moltbot-plugin-2do
npm install
npm run build
```

**从 Gitee 安装（国内推荐）：**

```bash
cd ~/.openclaw/skills
git clone https://gitee.com/akenz/moltbot-plugin-2do.git
cd moltbot-plugin-2do
npm install
npm run build
```

**更新已安装的插件：**

```bash
cd ~/.openclaw/skills/moltbot-plugin-2do
git pull
npm install
npm run build
```

> 如果同时配置了 GitHub 和 Gitee 远程仓库，可以指定拉取来源：
> - GitHub：`git pull origin master`
> - Gitee：`git pull gitee master`

### 配置

在 `~/.openclaw/openclaw.json` 中添加环境变量：

```json
{
  "skills": {
    "entries": {
      "moltbot-plugin-2do": {
        "enabled": true,
        "env": {
          "TWODO_EMAIL": "your-2do-email@example.com",
          "SMTP_HOST": "smtp.gmail.com",
          "SMTP_PORT": "587",
          "SMTP_USER": "your-email@gmail.com",
          "SMTP_PASS": "your-app-specific-password",
          "TITLE_PREFIX": "2Do:"
        }
      }
    }
  }
}
```

| 环境变量 | 说明 | 必需 |
|---------|------|------|
| `TWODO_EMAIL` | 2Do 中配置的接收邮箱地址 | 是 |
| `SMTP_HOST` | SMTP 服务器地址（如 smtp.gmail.com） | 是 |
| `SMTP_PORT` | SMTP 端口（587 为 STARTTLS，465 为 SSL） | 是 |
| `SMTP_USER` | SMTP 用户名 | 是 |
| `SMTP_PASS` | SMTP 密码（推荐使用[应用专用密码](https://support.google.com/accounts/answer/185833)） | 是 |
| `TITLE_PREFIX` | 邮件标题前缀，用于匹配 2Do 邮件捕获规则（可选） | 否 |

### 可选配置说明

**TITLE_PREFIX**：如果配置了此参数，所有发送的邮件标题会自动添加该前缀。例如设置 `TITLE_PREFIX="2Do:"`，则任务"开会"的邮件标题会变为 `2Do:开会 list(...) tag(...)`。

此功能可以帮助你在 2Do 中设置更精确的邮件捕获规则，只捕获带有特定前缀的邮件，避免其他邮件被误捕获。

### 配置 2Do App

1. 购买并启用 **Email to 2Do** 插件（iOS/Mac 应用内购买）
2. 在 2Do 设置 > Email to 2Do > Add Account 中添加邮箱
3. 配置捕获规则（推荐设置特定发件人规则）

详细指南参考 [2Do Email to 2Do 知识库](https://www.2doapp.com/kb/category/ios/email-to-2do/44/)。

## 项目状态

### 当前版本：v1.0.2

**已完成功能**：

- 核心 MVP 功能
  - 自然语言任务解析（支持多种中文表达方式）
  - 列表指定（"到X列表"、"列表是X"、", list X"）
  - 标签指定（"标签是X和Y"、", tag X and Y"）
  - 2Do 邮件格式构造
  - SMTP 邮件发送（支持 TLS/SSL）

- 2Do 日期/时间集成
  - 任务日期自动转换为 2Do 的 `start()`/`due()` 格式
  - 仅日期时设置截止时间：`due(M-D-YY)`
  - 含时间时同时设置开始和截止时间：`start(M-D-YY Ham/pm) due(M-D-YY Ham/pm)`

- 邮件标题前缀功能
  - 可配置 TITLE_PREFIX 环境变量
  - 自动在邮件标题前添加指定前缀
  - 帮助精确匹配 2Do 邮件捕获规则

- 广泛的意图识别
  - 基于 AgentSkills 规范的 description 触发机制
  - 支持固定前缀触发（添加任务、创建待办、提醒我等）
  - 支持自然表达触发（帮我记一下、别忘了、明天要...等）
  - 无需固定命令格式，自然对话即可创建任务

- 日期/时间提取
  - 相对日期：今天、明天、后天、大后天
  - 星期表达：周一~周日、下周X、星期X
  - 具体日期：X月X日/号
  - 时间：上午/下午/晚上 X点 X分/半
  - 日期+时间组合：明天下午3点

- 中英文双语支持
  - 英文命令前缀：add task、create todo、remind me to、remember to
  - 英文列表和标签：, list X、, tag X and Y
  - 大小写不敏感

- 优先级提取
  - 中文：紧急/加急(高)、重要(中)、不急(低)
  - 英文：urgent(高)、important(中)、low priority(低)

- 测试覆盖
  - 71 个单元测试覆盖核心功能
  - 覆盖日期解析、2Do 日期格式、任务解析、邮件构造等

**代码质量**：
- TypeScript 类型安全
- 完整的文档和使用示例
- 符合 AgentSkills 规范
- MIT 开源协议

### 未来规划

- [ ] 任务确认交互（发送前预览，支持修改后再发送）
- [ ] 批量任务添加（一次解析多个任务）
- [ ] 自定义邮件模板
- [ ] 配置验证命令（测试 SMTP 连接）
- [ ] 发布到 ClawHub 技能市场
- [ ] 国际化支持（i18n）

---

## 开发

```bash
# 安装依赖
pnpm install

# 运行测试
pnpm test

# 构建
pnpm build

# 类型检查
pnpm typecheck
```

## License

[MIT](LICENSE)
