# moltbot-plugin-2do - Moltbot Skill

## 项目概述

这是一个 Moltbot (OpenClaw) 插件项目，允许用户通过任何 Moltbot 支持的消息平台（QQ、企业微信、Slack、iMessage、Telegram、WhatsApp、Discord 等）以自然语言告诉 Moltbot 待办任务，Moltbot 会将任务通过邮件发送至用户配置的 2Do 邮箱，利用 2Do app 的 Email to 2Do 功能自动捕获并添加任务。

## 项目目标

1. **核心功能**：解析用户的自然语言输入，提取任务信息，通过邮件发送到 2Do
2. **开源发布**：发布到 ClawHub 插件市场，并在 GitHub 开源
3. **跨平台支持**：支持所有 Moltbot 支持的消息渠道

---

## 技术背景

### Moltbot (OpenClaw) 简介

Moltbot（现正式名称为 OpenClaw，原名 Clawdbot）是一个开源的自托管个人 AI 助手框架。

**核心特性：**
- 支持多消息平台：WhatsApp、Telegram、Discord、Slack、Signal、iMessage、企业微信等
- 通过 Skills 系统扩展功能
- 遵循 AgentSkills 规范（Anthropic 开发的开放标准）

**官方资源：**
- 官方文档：https://docs.openclaw.ai 或 https://docs.molt.bot
- GitHub：https://github.com/openclaw/openclaw
- 技能市场：https://clawhub.com

### 2Do App Email 功能

2Do 是一款强大的任务管理应用，支持通过 Email to 2Do 插件将邮件自动转换为任务。

**邮件格式规范：**
- **邮件主题** → 任务标题
- **邮件正文** → 任务备注（Notes）
- **指定列表**：在主题末尾添加 `list(列表名)`
- **指定标签**：在主题末尾添加 `tag(标签1, 标签2)`
- **组合使用**：`任务标题 list(工作) tag(紧急, 重要)`

**2Do Email 工作原理：**
1. 用户在 2Do 中配置 IMAP 邮箱账户
2. 2Do 监控该邮箱的 INBOX 文件夹
3. 根据配置的规则（如特定发件人、主题关键词、标记邮件等）捕获邮件
4. 将符合条件的邮件转换为任务

**支持的邮箱类型：**
- Gmail（推荐，支持 OAuth 2.0）
- iCloud
- Outlook/Office 365（仅 IMAP）
- 其他支持 IMAP 的邮箱

---

## 项目架构

### 目录结构

```
2do-task-email/
├── SKILL.md                    # Moltbot Skill 定义文件（必需）
├── README.md                   # 项目说明文档
├── LICENSE                     # 开源许可证
├── src/
│   ├── email-sender.ts         # 邮件发送核心模块
│   ├── task-parser.ts          # 自然语言任务解析器
│   ├── config.ts               # 配置管理
│   └── types.ts                # TypeScript 类型定义
├── scripts/
│   └── send-task.sh            # 发送任务的 shell 脚本（可选）
├── tests/
│   └── task-parser.test.ts     # 单元测试
├── examples/
│   └── usage-examples.md       # 使用示例
└── docs/
    ├── setup-guide.md          # 配置指南
    └── 2do-email-setup.md      # 2Do 邮箱配置指南
```

### SKILL.md 规范

Skill 文件必须遵循 AgentSkills 规范，包含 YAML frontmatter 和 Markdown 说明：

```markdown
---
name: moltbot-plugin-2do
description: 通过自然语言创建任务并发送到 2Do app，支持列表和指定标签
emoji: ✅
version: 1.0.0
author: chuckiefan
homepage: https://github.com/chuckiefan/moltbot-plugin-2do
metadata:
  openclaw:
    requires:
      env:
        - TWODO_EMAIL          # 2Do 配置的邮箱地址
        - SMTP_HOST            # SMTP 服务器地址
        - SMTP_PORT            # SMTP 端口
        - SMTP_USER            # SMTP 用户名
        - SMTP_PASS            # SMTP 密码（或应用专用密码）
      bins: []                 # 不需要额外的 CLI 工具
---

# 2Do Task Email

通过自然语言创建任务并自动发送到你的 2Do app。

## 功能

- 解析自然语言任务描述
- 支持指定任务列表和标签
- 通过邮件发送到 2Do
- 支持所有 Moltbot 消息渠道

## 使用方式

### 基本用法

告诉我: "添加任务：明天下午3点开会"

### 指定列表

告诉我: "添加任务到工作列表：完成项目报告"

### 指定标签

告诉我: "添加任务：买菜，标签是家务和购物"

### 完整示例

告诉我: "添加任务：周五前提交代码审查，列表是工作，标签是紧急和开发"

## 配置

在使用前，请确保已配置以下环境变量：

1. `TWODO_EMAIL` - 你在 2Do 中配置的邮箱地址
2. `SMTP_HOST` - 发送邮件的 SMTP 服务器
3. `SMTP_PORT` - SMTP 端口（通常是 587 或 465）
4. `SMTP_USER` - SMTP 用户名
5. `SMTP_PASS` - SMTP 密码

## 实现细节

当用户请求添加任务时：

1. 解析用户输入，提取任务标题、列表名、标签
2. 构造邮件主题：`{任务标题} list({列表名}) tag({标签1}, {标签2})`
3. 构造邮件正文：包含任务详情和创建时间
4. 通过 SMTP 发送邮件到用户的 2Do 邮箱
5. 确认任务已发送
```

---

## 核心功能实现

### 1. 自然语言解析

解析用户输入，支持以下格式：
- "添加任务：{任务内容}"
- "创建待办：{任务内容}"
- "提醒我：{任务内容}"
- "记录任务：{任务内容}，列表是{列表名}"
- "添加任务：{任务内容}，标签是{标签1}和{标签2}"

**解析结果结构：**
```typescript
interface ParsedTask {
  title: string;          // 任务标题
  list?: string;          // 目标列表名（可选）
  tags?: string[];        // 标签数组（可选）
  notes?: string;         // 备注（可选）
  dueDate?: Date;         // 截止日期（可选，如果能从语义中提取）
}
```

### 2. 邮件构造

根据 2Do 的邮件格式规范构造邮件：

**邮件主题格式：**
```
{任务标题}[ list({列表名})][ tag({标签1}, {标签2}, ...)]
```

**邮件正文格式：**
```
任务详情：{原始用户输入}

创建时间：{ISO 时间戳}
来源：Moltbot 2Do Task Email Skill
```

### 3. 邮件发送

使用 SMTP 协议发送邮件，支持：
- TLS/SSL 加密
- 应用专用密码（推荐用于 Gmail、iCloud 等）
- 错误处理和重试机制

---

## 配置要求

### 用户需要配置的环境变量

在 `~/.openclaw/openclaw.json` 中配置：

```json
{
  "skills": {
    "entries": {
      "2do-task-email": {
        "enabled": true,
        "env": {
          "TWODO_EMAIL": "your-2do-email@example.com",
          "SMTP_HOST": "smtp.gmail.com",
          "SMTP_PORT": "587",
          "SMTP_USER": "your-email@gmail.com",
          "SMTP_PASS": "your-app-specific-password"
        }
      }
    }
  }
}
```

### 2Do App 配置

用户需要在 2Do 中完成以下配置：

1. **启用 Email to 2Do 插件**（iOS/Mac App 内购买）
2. **添加邮箱账户**：
   - 设置 > Email to 2Do > Add Account
   - 选择邮箱类型（Gmail/iCloud/Other）
   - 完成 OAuth 或输入 IMAP 凭据
3. **配置捕获规则**（推荐）：
   - 设置特定发件人规则
   - 或设置特定主题关键词
   - 或使用"捕获所有邮件"模式

---

## 开发计划

### Phase 1: 基础功能 (MVP)

- [ ] 创建项目结构和 SKILL.md
- [ ] 实现基础任务解析（提取任务标题）
- [ ] 实现邮件发送功能
- [ ] 基本错误处理
- [ ] 编写使用文档

### Phase 2: 增强解析

- [ ] 支持列表指定（自然语言）
- [ ] 支持标签指定（自然语言）
- [ ] 支持日期/时间提取（"明天"、"下周一"等）
- [ ] 中英文双语支持

### Phase 3: 高级功能

- [ ] 任务确认交互（发送前预览）
- [ ] 批量任务添加
- [ ] 自定义邮件模板
- [ ] 配置验证和健康检查命令

### Phase 4: 发布

- [ ] 完善 README 和文档
- [ ] 添加 LICENSE（推荐 MIT）
- [ ] 发布到 ClawHub
- [ ] 创建 GitHub 仓库并开源

---

## 技术栈建议

### 核心依赖

- **Node.js >= 18**（Moltbot 要求 Node.js >= 22）
- **TypeScript**（推荐，提供类型安全）
- **nodemailer**：邮件发送
- **date-fns** 或 **dayjs**：日期处理

### 开发依赖

- **vitest** 或 **jest**：单元测试
- **eslint** + **prettier**：代码规范
- **tsup** 或 **esbuild**：打包构建

---

## 安全注意事项

1. **敏感信息处理**：
   - SMTP 密码应使用应用专用密码
   - 环境变量不应写入日志
   - 支持加密存储配置

2. **输入验证**：
   - 验证邮箱地址格式
   - 防止邮件注入攻击
   - 限制任务标题长度

3. **隐私保护**：
   - 不收集用户数据
   - 不与第三方共享任务内容
   - 所有处理在本地完成

---

## 参考资源

### Moltbot/OpenClaw

- [OpenClaw Skills 文档](https://docs.openclaw.ai/tools/skills)
- [ClawHub - 技能市场](https://clawhub.com)
- [awesome-openclaw-skills](https://github.com/VoltAgent/awesome-openclaw-skills)
- [AgentSkills 规范](https://docs.openclaw.ai/tools/skills#format-agentskills--pi-compatible)

### 2Do App

- [2Do 官网](https://www.2doapp.com)
- [Email to 2Do 知识库](https://www.2doapp.com/kb/category/ios/email-to-2do/44/)
- [邮件捕获任务教程](https://www.2doapp.com/kb/article/learn-how-to-capture-emails-as-tasks.html)

### 邮件发送

- [Nodemailer 文档](https://nodemailer.com)
- [Gmail SMTP 设置](https://support.google.com/mail/answer/7126229)
- [Gmail 应用专用密码](https://support.google.com/accounts/answer/185833)

---

## 示例用户交互

### 基本任务

**用户**: 帮我添加一个任务：明天去超市买牛奶

**Moltbot**: ✅ 已创建任务并发送到你的 2Do：
- 任务：明天去超市买牛奶
- 列表：Inbox（默认）

### 指定列表和标签

**用户**: 添加任务到工作列表：周五前完成季度报告，标签是紧急和财务

**Moltbot**: ✅ 已创建任务并发送到你的 2Do：
- 任务：周五前完成季度报告
- 列表：工作
- 标签：紧急, 财务

### 批量任务

**用户**: 帮我添加三个任务到购物列表：买水果、买蔬菜、买零食

**Moltbot**: ✅ 已创建 3 个任务并发送到你的 2Do：
1. 买水果 → 购物列表
2. 买蔬菜 → 购物列表
3. 买零食 → 购物列表

---

## 项目命名建议

- **Skill 名称**: `2do-task-email` 或 `twodo-email-task`
- **显示名称**: 2Do Task Email / 2Do 邮件任务
- **GitHub 仓库**: `moltbot-plugin-2do`

---

## 联系方式

如有问题或建议，请通过以下方式联系：

- GitHub Issues
- Email: [chuckiefan@163.com]

---

*本文档最后更新：2026年2月*