---
name: moltbot-ha
description: Control Home Assistant smart home devices, lights, scenes, and automations via moltbot-ha CLI with configurable safety confirmations.
homepage: https://github.com/iamvaleriofantozzi/moltbot-ha
metadata: {"moltbot":{"emoji":"🏠","requires":{"bins":["moltbot-ha"],"env":["HA_TOKEN"]},"primaryEnv":"HA_TOKEN","install":[{"id":"uv","kind":"uv","package":"moltbot-ha","bins":["moltbot-ha"],"label":"Install moltbot-ha (uv tool)"}]}}
---

# Home Assistant Control

Control your smart home via Home Assistant API using the `moltbot-ha` CLI tool.

## Setup

### 1. Install moltbot-ha
```bash
uv tool install moltbot-ha
```

### 2. Initialize Configuration
```bash
moltbot-ha config init
```

The setup will interactively ask for:
- Home Assistant URL (e.g., `http://192.168.1.100:8123`)
- Token storage preference (environment variable recommended)

### 3. Set Environment Variable
Set your Home Assistant long-lived access token:
```bash
export HA_TOKEN="your_token_here"
```

To create a token:
1. Open Home Assistant → Profile (bottom left)
2. Scroll to "Long-Lived Access Tokens"
3. Click "Create Token"
4. Copy the token and set as `HA_TOKEN` environment variable

### 4. Test Connection
```bash
moltbot-ha test
```

## Discovery Commands

### List All Entities
```bash
moltbot-ha list
```

### List by Domain
```bash
moltbot-ha list light
moltbot-ha list switch
moltbot-ha list cover
```

### Get Entity State
```bash
moltbot-ha state light.kitchen
moltbot-ha state sensor.temperature_living_room
```

## Action Commands

### Turn On/Off
```bash
# Turn on
moltbot-ha on light.living_room
moltbot-ha on switch.coffee_maker

# Turn off
moltbot-ha off light.bedroom
moltbot-ha off switch.fan

# Toggle
moltbot-ha toggle light.hallway
```

### Set Attributes
```bash
# Set brightness (percentage)
moltbot-ha set light.bedroom brightness_pct=50

# Set color temperature
moltbot-ha set light.office color_temp=300

# Multiple attributes
moltbot-ha set light.kitchen brightness_pct=80 color_temp=350
```

### Call Services
```bash
# Activate a scene
moltbot-ha call scene.turn_on entity_id=scene.movie_time

# Set thermostat temperature
moltbot-ha call climate.set_temperature entity_id=climate.living_room temperature=21

# Close cover (blinds, garage)
moltbot-ha call cover.close_cover entity_id=cover.garage
```

### Generic Service Call
```bash
# With parameters
moltbot-ha call automation.trigger entity_id=automation.morning_routine

# With JSON data
moltbot-ha call script.turn_on --json '{"entity_id": "script.bedtime", "variables": {"brightness": 10}}'
```

## Safety & Confirmations

moltbot-ha implements a **3-level safety system** to prevent accidental actions:

### Safety Level 3 (Default - Recommended)

Critical operations require explicit confirmation:
- **lock.***: Door locks
- **alarm_control_panel.***: Security alarms
- **cover.***: Garage doors, blinds

### How Confirmation Works

1. **Attempt critical action:**
```bash
moltbot-ha on cover.garage
```

2. **Tool returns error:**
```
⚠️  CRITICAL ACTION REQUIRES CONFIRMATION

Action: turn_on on cover.garage

This is a critical operation that requires explicit user approval.
Ask the user to confirm, then retry with --force flag.

Example: moltbot-ha on cover.garage --force
```

3. **Agent sees this error and asks you:**
> "Opening the garage door is a critical action. Do you want to proceed?"

4. **You confirm:**
> "Yes, open it"

5. **Agent retries with --force:**
```bash
moltbot-ha on cover.garage --force
```

6. **Action executes successfully.**

### Important: Never Use --force Without User Consent

**⚠️ CRITICAL RULE FOR AGENTS:**

- **NEVER** add `--force` flag without explicit user confirmation
- **ALWAYS** show the user which critical action is being attempted
- **WAIT** for explicit "yes" / "confirm" / "approve" before using `--force`
- **BE SMART** about what constitutes confirmation: "Yes", "OK", "Sure", "Do it", "Confirmed", or any affirmative response in the context of the request is sufficient. You do NOT need the user to type a specific phrase verbatim.

### Blocked Entities

Some entities can be permanently blocked in configuration:
```toml
[safety]
blocked_entities = ["switch.main_breaker", "lock.front_door"]
```

These **cannot** be controlled even with `--force`.

### Configuration

Edit `~/.config/moltbot-ha/config.toml`:

```toml
[safety]
level = 3  # 0=disabled, 1=log-only, 2=confirm all writes, 3=confirm critical

critical_domains = ["lock", "alarm_control_panel", "cover"]

blocked_entities = []  # Add entities that should never be automated

allowed_entities = []  # If set, ONLY these entities are accessible (supports wildcards)
```

## Common Workflows

### Morning Routine
```bash
moltbot-ha on light.bedroom brightness_pct=30
moltbot-ha call cover.open_cover entity_id=cover.bedroom_blinds
moltbot-ha call climate.set_temperature entity_id=climate.bedroom temperature=21
```

### Night Mode
```bash
moltbot-ha off light.*  # Requires wildcard support in future
moltbot-ha call scene.turn_on entity_id=scene.goodnight
moltbot-ha call cover.close_cover entity_id=cover.all_blinds
```

### Check Sensors
```bash
moltbot-ha state sensor.temperature_living_room
moltbot-ha state sensor.humidity_bathroom
moltbot-ha state binary_sensor.motion_hallway
```

## Troubleshooting

### Connection Failed
- Verify `HA_URL` in config matches your Home Assistant URL
- Ensure Home Assistant is reachable from the machine running moltbot-ha
- Check firewall settings

### 401 Unauthorized
- Verify `HA_TOKEN` is set correctly
- Ensure token is a **Long-Lived Access Token** (not temporary)
- Check token hasn't been revoked in Home Assistant

### Entity Not Found
- Use `moltbot-ha list` to discover correct entity IDs
- Entity IDs are case-sensitive
- Format is `domain.entity_name` (e.g., `light.kitchen`, not `Light.Kitchen`)

### Docker Networking
If running in Docker and can't reach Home Assistant on `homeassistant.local`:
- Use IP address instead: `http://192.168.1.100:8123`
- Or use Tailscale for reliable mesh networking

## Configuration Reference

Full config file (`~/.config/moltbot-ha/config.toml`):

```toml
[server]
url = "http://homeassistant.local:8123"
# token = "optional_here_prefer_env_var"

[safety]
level = 3
critical_domains = ["lock", "alarm_control_panel", "cover"]
blocked_entities = []
allowed_entities = []

[logging]
enabled = true
path = "~/.config/moltbot-ha/actions.log"
level = "INFO"
```

## Examples for Agents

### Discovery Pattern
```
User: "What lights do I have?"
Agent: moltbot-ha list light
Agent: "You have these lights: light.living_room, light.kitchen, light.bedroom"
```

### Safe Action Pattern
```
User: "Turn on the living room light"
Agent: moltbot-ha on light.living_room
Agent: "Living room light is now on"
```

### Critical Action Pattern
```
User: "Open the garage"
Agent: moltbot-ha on cover.garage
<receives CriticalActionError>
Agent: "⚠️ Opening the garage door is a critical action. Do you want to proceed?"
User: "Yes, open it"
Agent: moltbot-ha on cover.garage --force
Agent: "Garage door is opening"
```

## Notes

- All write actions are logged to `~/.config/moltbot-ha/actions.log` by default
- Safety settings are configurable per installation
- Wildcards (`*`) are supported in `allowed_entities` and `blocked_entities`
- JSON output available with `--json` flag for programmatic parsing
