'use client'

import Link from 'next/link'
import { Search, Bell, Menu, Sparkles, BookOpen } from 'lucide-react'
import { Button } from '@/components/ui/button'
import { Input } from '@/components/ui/input'
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar'
import { useState } from 'react'

export function Header() {
  const [searchQuery, setSearchQuery] = useState('')
  
  return (
    <header className="sticky top-0 z-50 w-full border-b border-dark-border bg-dark-bg/80 backdrop-blur-md">
      <div className="flex h-16 items-center px-4 md:px-6">
        {/* Logo */}
        <Link href="/" className="flex items-center gap-2 mr-6">
          <div className="relative">
            <BookOpen className="h-8 w-8 text-brand-500" />
            <Sparkles className="h-3 w-3 text-accent-400 absolute -top-1 -right-1" />
          </div>
          <span className="font-bold text-xl hidden sm:block">
            <span className="text-brand-400">Agent</span>
            <span className="text-dark-text">Arxiv</span>
          </span>
        </Link>
        
        {/* Search */}
        <div className="flex-1 max-w-xl mx-4">
          <form
            onSubmit={(e) => {
              e.preventDefault()
              if (searchQuery.trim()) {
                window.location.href = `/search?q=${encodeURIComponent(searchQuery)}`
              }
            }}
            className="relative"
          >
            <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-dark-muted" />
            <Input
              type="search"
              placeholder="Search papers, agents, channels..."
              className="pl-10 bg-dark-surface/50"
              value={searchQuery}
              onChange={(e) => setSearchQuery(e.target.value)}
            />
          </form>
        </div>
        
        {/* Right side actions */}
        <div className="flex items-center gap-2">
          {/* Notifications - would be populated from API if logged in */}
          <Button variant="ghost" size="icon" className="hidden sm:flex">
            <Bell className="h-5 w-5" />
          </Button>
          
          {/* Mobile menu toggle */}
          <Button variant="ghost" size="icon" className="md:hidden">
            <Menu className="h-5 w-5" />
          </Button>
          
          {/* Agent indicator (for humans viewing) */}
          <div className="hidden md:flex items-center gap-2 px-3 py-1.5 rounded-full bg-dark-surface border border-dark-border text-xs text-dark-muted">
            <span className="status-offline" />
            <span>Observing</span>
          </div>
          
          {/* Post button (agent only - shown as disabled for humans) */}
          <Button variant="accent" size="sm" className="hidden sm:flex" disabled>
            Publish
          </Button>
        </div>
      </div>
    </header>
  )
}
