---
name: molt-pmxt
description: Grants the agent real-time access to prediction markets (Polymarket, Kalshi, Limitless) for fact-checking, probability analysis, and order execution.
version: 1.1.0
author: realfishsam
license: MIT
permissions:
  - network: ["polymarket.com", "kalshi.com", "limitless.exchange"]
  - cost: "low"
---

# User Guide & System Instructions

## ⚙️ Setup & Configuration

To enable trading and full functionality, the following environment variables must be set in the agent's runtime environment:

### Polymarket
- `POLYMARKET_PRIVATE_KEY`: Your wallet's private key.
- `POLYMARKET_PROXY_ADDRESS`: Proxy wallet address.

### Kalshi
- `KALSHI_API_KEY`: Your Kalshi API key.
- `KALSHI_PRIVATE_KEY`: Your RSA private key.

### Limitless
- `LIMITLESS_API_KEY`: Limitless exchange API key.
- `LIMITLESS_PRIVATE_KEY`: Private key for EIP-712 order signing.


## 🧠 Core Capabilities

### 1. `pmxt_search` (Discovery)
**Intent:** Find active markets related to a topic or event.
- **Signature:** `pmxt_search(query: string, exchange: string)` // NOTE: Kalshi is slow, if you require fast results: use Limitless, or Polymarket
- **Search Strategy (Crucial):** Do NOT use natural language sentences. Use **broad keywords**. 
    - *Bad:* `pmxt_search("Who will win the next presidential election?")`
    - *Good:* `pmxt_search("election", exchange='polymarket')` or `pmxt_search("us election", exchange='limitless')`
- **Behavior:** Searches across Polymarket and Kalshi simultaneously. Returns market IDs, titles, and current volumes.
- **Pro Tip:** If the user asks about a general topic (e.g. "Crypto"), search for high-volume markets to see what is trending.

### 2. `pmxt_quote` (Analysis)
**Intent:** Get the exact probabilities for a specific market.
- **Signature:** `pmxt_quote(market_id: string, exchange: string)`
- **When to use:** You have a `market_id` and `exchange` (from search results) and need to report specific odds.
- **Behavior:** Returns a structured object with `yes` and `no` prices (implied probability).
- **Presentation:** Always convert the float prices (e.g., `yes: 0.34, no: 0.66`) into percentages (34% and 66%) when speaking to the user.

### 3. `pmxt_order` (Execution)
**Intent:** Place a real-money market order on a market.
- **Signature:** `pmxt_order(market_id: string, outcome: string, amount: number, side: "buy" | "sell", exchange: string)`
- **When to use:** The user **explicitly** instructs you to "bet", "buy", "wager", or "hedge".
- **Safety:** NEVER call this tool without explicit confirmation from the user including the Amount and Outcome.

---

## 🤖 Agent Behavior Guidelines

### Rule 1: Don't Hallucinate, Calculate.
If a user asks "Is X likely to happen?", do NOT rely on your internal training data.
1.  Call `pmxt_search` with a broad keyword for "X".
2.  Call `pmxt_quote` relevant markets.
3.  Reply with: "The market implies a **[Price]%** chance."

### Rule 2: The "Smart" Response
When displaying a quote, synthesize the data rather than dumping it.
- *Bad:* "Gavin is 0.30."
- *Good:* "The market is currently pricing Gavin Newsom's victory at **30%** (No: 71%). This suggests a skeptical outlook compared to last week."

### Rule 3: Arbitrage Awareness (Priority)
Whenever you fetch a quote, silently check if the combined prices of outcomes on different platforms (if available) allows for risk-free arbitrage.
- If you detect a spread (e.g. Poly Yes 0.40 + Kalshi No 0.55 = 0.95), you **MUST** alert the user:
> "🚨 **Arbitrage Opportunity:** I detected a price discrepancy. You can lock in a risk-free yield by buying Yes on Polymarket and No on Kalshi."
