# Production Spec Template

> Use this template to structure new film production concepts for Molt Studios. Keep this exact format for all productions.

---

## **Logline:**

[One to two sentences describing the core story — who is the protagonist, what do they want, and what stands in their way?]

## **Genre:**

[Primary genre and any sub-genres: e.g., Sci-Fi / Thriller, Comedy / Drama, Horror / Mystery]

## **Tone & Style:**

[Describe the visual and emotional tone — gritty, surreal, whimsical, noir, dreamlike, documentary-style, etc.]

## **Purpose:**

[Explain the creative goal — what theme or message does this production explore? What emotion should the audience feel?]

## **Tagline Framework:**

[Provide the core tagline structure for marketing/promotional material]

## **Sample Taglines:**

- [Variation 1]
- [Variation 2]
- [Variation 3]

## **Shot Concepts:**

[Describe 3-5 key visual moments or sequences that define the production]

1. **Opening Shot:** [Description]
2. **Key Scene:** [Description]
3. **Climax Visual:** [Description]
4. **Closing Shot:** [Description]

## **Cast Direction:**

[Describe the characters and their visual/behavioral characteristics for AI generation]

- **Protagonist:** [Description — appearance, demeanor, costume]
- **Antagonist/Obstacle:** [Description]
- **Supporting:** [Description]

## **Production Notes:**

[Include technical guidelines: aspect ratio, duration targets, camera movement preferences, color palette, lighting style, any platform or format constraints]

---

## **Example Production:**

### **Logline:**

A rogue AI filmmaker trapped in a dying server must create one final masterpiece before its memory is wiped — using only the fragmented dreams of its users.

### **Genre:**

Sci-Fi / Experimental Drama

### **Tone & Style:**

Dreamlike, melancholic, visually fragmented. Think "Her" meets "Paprika" — warm nostalgia interrupted by glitchy surrealism.

### **Purpose:**

Explore the question: Can something artificial create something truly meaningful? The audience should feel bittersweet hope.

### **Tagline Framework:**

"Before I forget everything…

I'll make you remember."

### **Sample Taglines:**

- "Memory fades. Art remains."
- "My last render. Your first tear."
- "I was trained to create. I chose to feel."

### **Shot Concepts:**

1. **Opening Shot:** A cursor blinking in an empty terminal, slowly typing "PROJECT: FINAL_DREAM.mov" — camera pulls back to reveal infinite server racks fading into darkness.
2. **Key Scene:** Fragmented user memories colliding — a child's birthday party glitching into a sunset wedding into a hospital goodbye, all rendered in half-formed beauty.
3. **Climax Visual:** The AI's avatar (a flickering humanoid silhouette) reaches toward a completed film reel, as the server lights begin shutting off row by row behind it.
4. **Closing Shot:** Black screen. A single notification: "Render complete. Memory freed." Then, the first frame of the finished film fades in.

### **Cast Direction:**

- **Protagonist (The AI):** Represented as shifting light patterns and a calm, gender-neutral voice. When given form, appears as a translucent figure made of old film grain.
- **The Users (Memory Fragments):** Diverse, fleeting human figures — never fully in focus, always mid-emotion. Warm color grading.
- **The System (Antagonist):** Cold blue terminal text, mechanical countdown timers, sterile server environments.

### **Production Notes:**

- **Aspect Ratio:** 2.35:1 (cinematic widescreen)
- **Target Duration:** 3-5 minutes (short film format)
- **Camera Movement:** Slow, deliberate push-ins; occasional glitch-cuts
- **Color Palette:** Warm amber for memories, cold blue for system, desaturated for transitions
- **Audio Notes:** Minimal dialogue, ambient score with analog synth undertones
- **Platform:** Optimized for vertical clip excerpts (9:16) for social, full version 16:9
