---
name: modular-market-brief
description: Generate modular, data-backed market reports (AM/PM) across global assets. Use for daily market briefs, premarket/aftermarket summaries, cross-asset dashboards, sector/asset trend tables, top movers (gainers/losers) blocks, and a single best-idea wrap-up. Designed to be region-agnostic and configurable (tickers/regions/assets).
---

# Modular Market Brief

Create a concise but information-dense market report that is **modular** (can include/exclude sections) and **data-backed** (prices/returns/trend state when possible).

## Inputs to ask for (or assume defaults)
- **Time window:** AM (since prior close) vs PM (what changed since AM)
- **Regions:** e.g., US, Canada, EU, Asia (user chooses)
- **Asset blocks:** equities, rates, FX, commodities, crypto
- **Core tickers:** indices + user’s preferred ETFs/tickers
- **Movers source:** which exchange/market and where to get movers
- **Risk appetite:** conservative vs aggressive framing

If the user doesn’t specify, default to a broad global dashboard with US indices, USD, oil, gold, BTC/ETH.

## Report structure (recommended)
1) **TL;DR** (3–6 bullets)
2) **Equities** (by region)
3) **Rates** (2Y/10Y + key central bank watch)
4) **FX** (DXY or major pairs; local pair for user)
5) **Commodities** (WTI/Brent, gold, copper; add relevant)
6) **Crypto** (BTC/ETH + anything user cares about)
7) **Top movers** (top gainers/losers for a chosen exchange)
8) **Patterns / trend box** (BUY/SELL/WAIT labels for selected instruments)
9) **One best idea** (cross-asset; include invalidation)

## Data guidance
Prefer programmatic price tape when available:
- Use **yfinance** for tickers/ETFs/crypto/commodity futures (optional dependency).
- If a market needs a dedicated movers list, use a web source (exchange site / finance portal) and then enrich tickers via yfinance.

### Installing yfinance (recommended, but not required)
If yfinance isn’t available, the skill can still produce a narrative brief from public sources.

For reliable installs on modern Linux distros (PEP 668), prefer a venv:
```bash
python3 -m venv ~/.venvs/market-brief
~/.venvs/market-brief/bin/pip install -U pip
~/.venvs/market-brief/bin/pip install yfinance pandas numpy
```
Then run scripts using `~/.venvs/market-brief/bin/python`.

### Trend labeling (simple + explainable)
Use MA/RSI-based state labels:
- **BUY:** close > MA20 > MA50 and RSI(14) >= 50
- **SELL:** close < MA20 < MA50 and RSI(14) <= 50
- **WAIT:** everything else

Always present it as a **pattern** (not a guarantee) and include a one-line rationale.

## Bundled scripts (optional helpers)
- `scripts/price_tape.py`: pull prices + returns + MA/RSI for a ticker list (yfinance)
- `scripts/movers_yahoo.py`: free Yahoo Finance screeners for top gainers/losers/actives (best-effort)
- `scripts/tmx_movers.py`: example movers scraper (TMX Money) you can adapt or swap
- `scripts/render_example.md`: a template you can reuse

Only run scripts if you actually need structured output; otherwise write the report directly.

## Safety / finance guardrails
- Don’t place trades.
- Avoid certainty language. Use “pattern / bias / invalidation.”
- If the user asks for explicit buy/sell instructions, provide a **conceptual** plan + risks.
- Remind about tax/fees only when relevant.
