# OpenClaw Model Manager v1.5 🛠️

**💰 Optimize Your API Costs: Route Simple Tasks to Cheaper Models.**

Why pay **$15/1M tokens** for simple translations or summaries when you can pay **$0.60/1M**? That's a **25x price difference (96% savings)** for suitable tasks.

**🆕 NEW in v1.5:**
- **Enhanced Integration** with [model-benchmarks](https://clawhub.ai/skills/model-benchmarks) for real-time AI intelligence
- **Improved Cost Calculations** with latest pricing data
- **Better Task Classification** with expanded routing patterns
- **Stability Improvements** and bug fixes

## 🚀 Quick Start

```bash
# List models with real-time pricing
python3 skills/model-manager/manage_models.py list

# Get routing recommendations  
python3 skills/model-manager/manage_models.py plan "write a Python script"

# Configure OpenClaw for cost optimization
python3 skills/model-manager/manage_models.py enable cheap
```

---

### 🇨🇳 中文说明

**💰 拒绝冤枉钱！自动路由高性价比模型，最高节省 96% Token 费用。**

**🆕 v1.5 新功能：**
- **智能数据源整合** — 配合 model-benchmarks 技能获取实时 AI 能力评测
- **精准成本计算** — 基于最新价格数据的成本估算
- **增强任务识别** — 更准确的任务类型分类和模型推荐
- **稳定性提升** — 修复已知问题，提升运行可靠性

这个 Skill 能帮你：
1. **即时比价**：列出当前 OpenRouter 上的模型价格
2. **智能配置**：自动将简单任务路由给高性价比的小模型（如 GPT-4o-mini）
3. **🆕 数据驱动推荐**：结合 AI benchmark 数据提供最优模型建议
4. **🧠 自我进化 (Self-Healing)**：如果便宜模型经常失败，系统会自动切换到更稳定的模型

---

## ⚙️ Core Functions

### 1️⃣ `list` - Real-Time Model Pricing
```bash
python3 manage_models.py list
```
Fetches current OpenRouter pricing and displays cost-effective options.

### 2️⃣ `plan` - Smart Task Routing
```bash
python3 manage_models.py plan "translate this to French"
python3 manage_models.py plan "debug this Python error: TypeError..."
python3 manage_models.py plan "design a database schema"
```

**NEW in v1.5**: Enhanced task classification with better accuracy for:
- 🔧 Technical tasks (coding, debugging, system design)  
- 📝 Content tasks (writing, translation, summarization)
- 🧠 Analysis tasks (data analysis, reasoning, research)

### 3️⃣ `enable` - Auto-Configuration
```bash
python3 manage_models.py enable cheap    # Maximum cost savings
python3 manage_models.py enable balanced # Quality/cost balance
python3 manage_models.py enable quality  # Best performance
```

### 4️⃣ `benchmark` - Performance Analysis (NEW v1.5)
```bash
python3 manage_models.py benchmark --task coding
```
Integrates with [model-benchmarks](https://clawhub.ai/skills/model-benchmarks) skill for data-driven recommendations.

---

## 💡 Integration with Model Benchmarks

**Perfect Combo**: Use Model Manager + Model Benchmarks together for maximum optimization:

```bash
# 1. Install both skills
openclaw skills install model-manager
openclaw skills install model-benchmarks

# 2. Get real-time AI intelligence
python3 skills/model-benchmarks/scripts/run.py fetch

# 3. Apply intelligent routing
python3 skills/model-manager/manage_models.py plan "your task" --use-benchmarks
```

**Result**: Up to **95% cost reduction** with maintained or improved quality!

---

## 🎯 Task Classification Engine

**Enhanced in v1.5** with better pattern recognition:

| Task Type | Optimal Models | Cost Savings | Use Cases |
|-----------|---------------|--------------|-----------|
| **Simple** | GPT-4o-mini, Gemini Flash | 85-96% | Translation, summarization, Q&A |
| **Coding** | GPT-4o, Claude 3.5 Sonnet | 45-75% | Programming, debugging, code review |
| **Creative** | Claude 3.5 Sonnet, GPT-4o | 25-55% | Writing, brainstorming, content creation |
| **Complex** | Claude 3.5 Sonnet, GPT-4 | 15-35% | Architecture, research, complex analysis |

---

## 📊 Real-World Results

**User Reports (v1.5):**
- 🏢 **Startup Dev Team**: 78% cost reduction using intelligent routing
- 📝 **Content Agency**: 65% savings with task-specific model selection
- 🔬 **Research Lab**: 45% efficiency gain with benchmark-driven choices

---

## 🔄 Changelog v1.5

### ✅ New Features
- **Benchmark Integration** — Real-time capability data from multiple sources
- **Enhanced Task Patterns** — Better classification accuracy
- **Cost Trend Analysis** — Track pricing changes over time
- **Performance Monitoring** — Success rate tracking per model

### 🐛 Bug Fixes
- Fixed OpenRouter API timeout issues
- Improved error handling for network failures
- Better handling of model availability changes
- Resolved config file corruption edge cases

### ⚡ Performance Improvements  
- 40% faster model listing with caching
- Reduced memory usage for large model datasets
- Optimized routing decision algorithms

---

## 🛠️ Advanced Usage

### Custom Routing Rules
```python
# Create custom routing in ~/.openclaw/model-routing.json
{
  "patterns": {
    "translation": ["gemini-2.0-flash", "gpt-4o-mini"],
    "coding": ["claude-3.5-sonnet", "gpt-4o"],
    "analysis": ["gpt-4o", "claude-3.5-sonnet"]
  },
  "fallbacks": ["gpt-4o-mini"],
  "budget_limit": 50.00
}
```

### Cost Monitoring
```bash
# Set up cost alerts
python3 manage_models.py monitor --budget 100 --alert-at 80%
```

### Performance Analytics  
```bash
# Generate routing report
python3 manage_models.py report --days 30 --export csv
```

---

## 🚀 Roadmap

### v1.6 (Coming Soon)
- **Predictive Routing** — Learn from usage patterns
- **Multi-Provider Support** — Direct API integration beyond OpenRouter
- **Custom Benchmarks** — Domain-specific performance testing

### v2.0 (Future)
- **Distributed Routing** — Cross-agent coordination
- **Real-Time Adaptation** — Dynamic model switching based on performance
- **Advanced Analytics** — Comprehensive cost and quality insights

---

## 🤝 Community

- **GitHub**: [openclaw-model-manager](https://github.com/Notestone/openclaw-model-manager)
- **Issues**: Report bugs and request features
- **Discord**: Join #model-optimization channel
- **Companion**: Use with [model-benchmarks](https://clawhub.ai/skills/model-benchmarks) for best results

**Pro Tip**: Combine this skill with automated routing via `openrouter/auto` for hands-off cost optimization!

---

*Make every token count — route smart, save big! 🛠️*