---
name: jisu-mobileempty
description: 使用极速数据手机空号检测 API，一次性批量检测手机号是否为空号、风险号、实号或沉默号。
metadata: { "openclaw": { "emoji": "📵", "requires": { "bins": ["python3"], "env": ["JISU_API_KEY"] }, "primaryEnv": "JISU_API_KEY" } }
---

# 极速数据手机空号检测（Jisu MobileEmpty）

基于 [手机空号检测 API](https://www.jisuapi.com/api/mobileempty/) 的 OpenClaw 技能，用于对三大运营商号码做批量检测，将号码划分为：**实号包、风险包、空号包、沉默包**。

适合在对话中回答「这批手机号哪些是空号」「帮我筛出活跃用户号码」「哪些号码存在风险」等问题。

使用技能前需要申请数据，申请地址：https://www.jisuapi.com/api/mobileempty/

## 环境变量配置

```bash
# Linux / macOS
export JISU_API_KEY="your_appkey_here"

# Windows PowerShell
$env:JISU_API_KEY="your_appkey_here"
```

## 脚本路径

脚本文件：`skills/mobileempty/mobileempty.py`

## 使用方式

### 批量检测手机号（最多 100 个）

```bash
python3 skills/mobileempty/mobileempty.py '{"mobiles":"18156080000,18156080001,18156080002"}'
```

请求 JSON 示例：

```json
{
  "mobiles": "18156080000,18156080001,18156080002"
}
```

## 请求参数

| 字段名   | 类型   | 必填 | 说明                          |
|----------|--------|------|-------------------------------|
| mobiles  | string | 是   | 待检测的号码，逗号分隔，最多 100 个 |

## 返回结果示例

脚本直接输出接口的 `result` 字段，结构与官网一致，例如：

```json
{
  "risk": [],
  "real": [],
  "empty": [],
  "unknown": [
    "18156080000",
    "18156080002",
    "18156080001"
  ]
}
```

字段含义：

- **risk**：风险包集合（长时间关机、未开通语音服务、易投诉用户等）  
- **real**：实号包集合（正常活跃用户）  
- **empty**：空号包集合（近 1 个月内出现过的空号、停机号）  
- **unknown**：沉默包集合（在网但不可用）  

## 错误返回示例

```json
{
  "error": "api_error",
  "code": 201,
  "message": "手机号为空"
}
```

## 常见错误码

来源于 [极速数据手机空号检测文档](https://www.jisuapi.com/api/mobileempty/)：

| 代号 | 说明                 |
|------|----------------------|
| 201  | 手机号为空           |
| 202  | 手机号有误           |
| 203  | 检测失败             |
| 204  | 手机号个数不得大于 100 |

系统错误码：101 APPKEY 为空或不存在、102 已过期、103 无请求权限、104 请求超过次数限制、105 IP 被禁止、106 IP 请求超过限制、107 接口维护中、108 接口已停用。

## 在 OpenClaw 中的推荐用法

1. 用户：「这 50 个号码有哪些是空号？」→ 将用户提供的号码整理成逗号分隔字符串，调用脚本，读取 `empty` 列表返回。  \n
2. 用户：「帮我筛出活跃用户号码」→ 调用接口后使用 `real` 结果，结合业务上下文整理为可直接用于下游发送的号码列表。  \n
3. 用户：「这批号码中哪些存在风险？」→ 关注返回中的 `risk`，并向用户解释风险含义（长时间关机、未开通语音、易投诉等）。  \n
4. 用户：「区分可用与沉默号码」→ 将 `real` 视为可用号码，将 `empty`/`unknown` 视为不可用或需谨慎使用的号码，并以表格或分组列表形式呈现。  \n

