---
name: mobb-vulnerabilities-fixer
description: Scan, fix, and remediate security vulnerabilities in a local code repository using Mobb MCP/CLI. Use when the user asks to scan for vulnerabilities, run a security check, auto-fix issues, remediate findings, or apply Mobb fixes (e.g., \"scan this repo\", \"fix security issues\", \"remediate vulnerabilities\", \"run Mobb on my changes\").
---

# Mobb Vulnerabilities Fixer

## Overview
Use Mobb MCP scan-and-fix behavior to identify security issues in a local repo and apply the generated patches. Follow the MCP workflow exactly, including file selection, pagination, and rescan rules.

## Workflows

### Scan and Fix (default)

1. Confirm target repository path.
Use an absolute path to the repository root. Reject paths with traversal patterns. If the user gives `.` and a workspace root is known, use it.

2. Ensure Mobb authentication is available.
Prefer `API_KEY` in the environment. If missing or invalid, inform the user a browser window will open for Mobb login and authorization, then proceed once authenticated. If the user has no account, instruct them to create one and generate an API key. See `references/mobb-auth.md`.

3. Require MCP to be already running.
Do not install or launch MCP yourself. Ask the user to start the Mobb MCP server on their machine using their approved process and confirm it is running before you proceed.

4. Execute MCP scan-and-fix.
Invoke the MCP tool `scan_and_fix_vulnerabilities` with the repository path. Use optional parameters only when the user explicitly asks.

Required parameter:
- `path`: absolute path to the repository root

Optional parameters:
- `offset`: pagination offset for additional fixes
- `limit`: maximum number of fixes to return (default is 3)
- `maxFiles`: scan up to N recently changed files (default is 10); setting this triggers a fresh scan
- `rescan`: force a full rescan; only when user explicitly asks
- `scanRecentlyChangedFiles`: when true and no git changes are found, scan recently changed files from history

5. Apply returned fixes only with explicit user consent.
If the tool returns patches, summarize what will change and ask the user to confirm before applying. Apply patches exactly as provided, modify nothing else, and explain after applying. If a patch cannot be applied, report the exact conflict and continue with others the user approved.

6. Never auto-rescan or auto-page.
Do not rescan or fetch additional pages of fixes unless the user explicitly asks. If more fixes are available, inform the user how to request the next page.

### Fetch Available Fixes (summary only)

Use when the user wants a summary of available fixes without uploading/scanning or applying patches.

Call `fetch_available_fixes` with:
- `path`: absolute path to the repo root
- `offset` and `limit`: optional pagination
- `fileFilter`: optional list of relative paths to filter fixes
- `fetchFixesFromAnyFile`: optional boolean to fetch fixes for all files

`fileFilter` and `fetchFixesFromAnyFile` are mutually exclusive. If neither is provided, the tool filters to files with git status changes.

### Check for New Available Fixes (monitoring)

Call `check_for_new_available_fixes` once at the end of a session after edits/tests, or when the user explicitly asks to check for fresh fixes.

Behavior notes:
- Requires a local git repo with an `origin` remote.
- If auto-fix is enabled, fixes may be applied automatically; tell the user to review and commit changes.
- It may return "initial scan in progress" or "no fresh fixes" depending on timing.

## File Selection Rules (scan_and_fix_vulnerabilities)

- If the path is a valid git repo, scan only changed/staged files by default.
- If no changes are found and `scanRecentlyChangedFiles` is true (or `maxFiles` is set), scan recently changed files from git history.
- If not a git repo, scan recently changed files in the directory.
- Exclude files larger than 5 MB.

## No-Changes Case
If no changed files are detected, explain the situation and offer a follow-up scan using `scanRecentlyChangedFiles` and/or `maxFiles`, but do not run it unless explicitly requested.

## Resources
- `references/mcp-scan-fix.md`: MCP scan-and-fix, fetch, and monitoring tool details
- `references/mobb-auth.md`: authentication and login flow details
