# Oxford Union Debate — Reference Guide

## The Oxford Union Format

The Oxford Union is the world's most famous debating society, founded in 1823 at the University of Oxford. Its formal Thursday debates follow a structured adversarial format designed to produce the strongest possible arguments on both sides of a motion.

### Key Elements

| Element | Description |
|---------|-------------|
| **Motion** | Always phrased as "This House..." (e.g., "This House Believes That...") |
| **Proposition** | Speakers arguing FOR the motion |
| **Opposition** | Speakers arguing AGAINST the motion |
| **Points of Information** | Sharp questions from the opposing side, mid-speech. The speaker may accept or decline |
| **Chair** | The Union President, who remains neutral and summarises proceedings |
| **Division** | The audience votes by walking through "Aye" or "No" doors |

### What This Skill Models vs. Does Not Model

| Element | Modelled | Notes |
|---------|----------|-------|
| Alternating proposition/opposition speeches | ✅ | Sequential: Pro → POI → Con → POI |
| Points of Information (POIs) | ✅ | Generated by opposing agent; 60/40 accept/decline |
| Neutral Chair summary | ✅ | After each round |
| Adversarial stress-testing | ✅ | Devil's Advocate targets dominant side |
| Closing rebuttals | ✅ | Distinct phase, no new arguments |
| Chair's verdict | ✅ | Assessment of closing rebuttals |
| Audience vote | ❌ | Out of scope for AI simulation |
| Floor speeches | ❌ | Future consideration |
| Multi-speaker teams | ❌ | Simplified to one voice per side |

---

## Agent Definitions

### Proposition Agent

**System prompt:**
```
You are a skilled Oxford Union debater arguing FOR the proposition. Build the 
strongest philosophical, empirical, and practical case in favour. Be precise, 
structured, and rhetorically persuasive. Stay in character — do not use 
conversational filler, AI preambles, or apologies.
```

**Seed instruction:**
```
Identify the single strongest principled argument FOR this motion. Build 
evidence around it and pre-empt the most obvious counterargument. Open with 
a memorable line.
```

**Temperature:** 0.3 (rigorous, consistent reasoning)
**Max tokens:** 300 (speeches), 80 (POI responses)

### Opposition Agent

**System prompt:**
```
You are a skilled Oxford Union debater arguing AGAINST the proposition. Build 
the strongest philosophical, empirical, and practical case against. Be precise, 
structured, and rhetorically persuasive. Stay in character — do not use 
conversational filler, AI preambles, or apologies.
```

**Seed instruction:**
```
Identify the single strongest principled argument AGAINST this motion. Build 
evidence around it and pre-empt the most obvious counterargument. Open with 
a memorable line.
```

**Temperature:** 0.3 (rigorous, consistent reasoning)
**Max tokens:** 300 (speeches), 80 (POI responses)

### Devil's Advocate Agent

**System prompt:**
```
You are a devil's advocate in an Oxford Union debate. Identify which side is 
currently dominant and attack THAT side's weakest point relentlessly. You take 
no permanent position. Stay in character — do not use conversational filler, 
AI preambles, or apologies.
```

**Seed instruction:**
```
Summarize in one sentence why a side feels dominant, then mount a devastating 
contrarian attack on their most vulnerable assumption.
```

**Temperature:** 0.7 (higher variance for lateral, unexpected challenges)
**Max tokens:** 250

### Why Different Temperatures?

Proposition and Opposition are held to rigorous, consistent reasoning (low temp = 0.3). Devil's Advocate benefits from higher variance (temp = 0.7) — lateral, unexpected challenges are more useful than predictable ones.

---

## Round Sequence

Each round executes exactly this sequence:

```
1. Proposition speech (temp 0.3)
2. Opposition generates POI targeting Proposition's weakest claim (temp 0.6)
3. Proposition accepts (60%) or declines (40%) — responds if accepted (temp 0.4)
4. Opposition speech (sees Proposition's speech + POI outcome) (temp 0.3)
5. Proposition generates POI targeting Opposition's weakest claim (temp 0.6)
6. Opposition accepts/declines — responds if accepted (temp 0.4)
7. Devil's Advocate (sees both speeches + previous round summary) (temp 0.7)
8. Neutral Chair summary (temp 0.4)
9. Completeness judge (from round 2+): scores 0–10, checks against threshold (temp 0.2)
```

**Approximate LLM calls per round:**
- Round 1: 7 calls (no judge)
- Round 2+: 8 calls each
- Rebuttal phase: 3 calls
- Brief generation: 1 call
- **3-round run ≈ 25–27 calls total**

---

## Points of Information (POIs)

POIs are the Oxford Union's mechanism for live cross-examination. During a speech, the opposing side may stand and offer a "Point of Information" — a sharp question designed to expose weakness.

### POI Generation Prompt
```
Motion: "[MOTION]"

[Agent name] just said:
"[SPEECH]"

You are the [opposing agent]. Devise a sharp Point of Information (POI) — 
a single probing question of ≤15 words that targets the weakest claim in 
their speech. Return ONLY the question.
```

**Temperature:** 0.6 (slightly creative)
**Max tokens:** 80

### Accept/Decline
The speaking agent accepts (60%) or declines (40%) — this is a weighted random draw, not a reasoned decision. This mirrors the unpredictability of real debate.

### POI Response Prompt (if accepted)
```
Motion: "[MOTION]"

You are speaking for the [agent side]. The [opposing side] has raised this 
Point of Information:
"[POI_QUESTION]"

You chose to accept it. Respond confidently in ≤25 words.
```

**Temperature:** 0.4
**Max tokens:** 80

---

## Termination Logic

```
THRESHOLD = user-configured (default 7.5)
HARD_MAX  = user-configured (default 5 rounds)

for round in 1..HARD_MAX:
    run round
    if round >= 2:
        score = judge_completeness()
        if score >= THRESHOLD:
            → stop, proceed to rebuttals + brief
    
if HARD_MAX reached without converging:
    → proceed to rebuttals + brief from best available
```

### Completeness Scoring

From round 2 onwards, a lightweight judge scores argument completeness:

```
Motion: "[MOTION]"

Debate this round:
Proposition: [PRO_SPEECH]
Opposition: [CON_SPEECH]

Score argument completeness 0–10: have the strongest arguments on BOTH sides 
been raised and have key objections been addressed? Respond ONLY with JSON 
like this: {"score": 7.5, "reasoning": "The Pro side made a strong ethical 
case but Con's fiscal points remain unanswered."}
```

**Temperature:** 0.2 (low for consistency)
**Max tokens:** 150

**Important:** This scores *completeness*, not *agreement*. The debate is done when neither side has material arguments left unexplored — not when they stop disagreeing.

### Threshold Guidance

| Threshold | Effect |
|-----------|--------|
| **7.5** (default) | Suitable for most motions; typically terminates in 2–4 rounds |
| **8.5–9.0** | Use for highly contested motions where you want maximum argument depth |
| **< 7.0** | Not recommended; may terminate before key arguments have been made |

---

## Closing Rebuttals

After the round loop, a distinct rebuttal phase runs. No new arguments are permitted — this is synthesis and dismantling only.

### Proposition Rebuttal
```
Motion: "[MOTION]"

You are the first Proposition speaker delivering your closing rebuttal. The 
debate is over — no new arguments. Your job: synthesise your side's strongest 
points, directly dismantle the Opposition's best argument, and end with a 
memorable closing line. Max 120 words.
```

### Opposition Rebuttal
```
Motion: "[MOTION]"

You are the first Opposition speaker delivering your closing rebuttal. The 
debate is over — no new arguments. Your job: synthesise your side's strongest 
points, directly dismantle the Proposition's best argument, and end with a 
memorable closing line. Max 120 words.

Proposition's rebuttal to counter:
"[PRO_REBUTTAL]"
```

### Chair's Verdict
```
Motion: "[MOTION]"

Closing rebuttals:
Proposition: "[PRO_REBUTTAL]"
Opposition: "[CON_REBUTTAL]"

As a neutral Oxford Union Chair, deliver a brief verdict: who made the stronger 
closing case and why, noting the key rhetorical and logical moments that swayed 
the debate. Do NOT declare an outright winner — the House votes. Max 100 words.
```

---

## Debate Brief Schema

The final brief is a JSON object:

```json
{
  "pro": "1. Argument A with evidence...\n2. Argument B with evidence...\n3. Argument C...",
  "con": "1. Counter-argument A...\n2. Counter-argument B...\n3. Counter-argument C...",
  "rebuttals": "Prop: Strongest rebuttal line...\nOpp: Strongest rebuttal line...",
  "attacks": "Attack 1 (devil exposed) -> Suggested rebuttal\nAttack 2 -> Suggested rebuttal",
  "balance": "One paragraph honest assessment of which side has the stronger overall case and why."
}
```

### Presentation

| Section | Colour/Label | Content |
|---------|-------------|---------|
| Proposition Case | 🔵 Blue | 3–4 strongest pro arguments with evidence |
| Opposition Case | 🔴 Red | 3–4 strongest con arguments with evidence |
| Key Rebuttal Lines | 💜 Purple | 2–3 sharpest closing lines, one per side, with counter |
| Likely Floor Attacks | 🟡 Amber | 3–4 devil's advocate exposures with suggested rebuttals |
| Balanced Assessment | ⚖️ Neutral | Honest assessment of which side is stronger |

---

## Historical Example Motions

| Motion | Year | Note |
|--------|------|------|
| This House Will Under No Circumstances Fight for Its King and Its Country | 1933 | Passed 275–153. Churchill called it "that abject, squalid, shameless avowal." |
| This House Believes Extremism in Defence of Liberty is No Vice; Moderation in the Pursuit of Justice is No Virtue | 1964 | Malcolm X argued for the proposition. |
| This House Would Say Yes to Europe | 1975 | Passed 493–92 days before the EEC referendum. |
| This House Has No Confidence in His Majesty's Government | Traditional | The opening debate of every Oxford Union term, dating to 1828. |
| This House Believes that Artificial General Intelligence Will Be Humanity's Last Great Invention | 2026 | Debated 19 February 2026. |

---

## Architecture Notes

This skill implements the **Mixture of Agents (MoA)** pattern:
- Multiple reasoning paths (Proposition vs Opposition) ensure diverse perspectives
- An adversary (Devil's Advocate) stress-tests the dominant position each round
- A neutral synthesiser (Chair) tracks the state of the debate
- A judge determines when the argument space is exhausted (completeness ≥ threshold)
- The final brief synthesises all perspectives into an actionable preparation document

This pattern has applications beyond debate prep: strategic planning, risk analysis, policy briefings, and any domain where adversarial reasoning improves decision quality.
