# MISO開発ストーリー：ダッシュボード疲れをなくす

## なぜMISOを作ったのか

AIエージェントが同時に複数走るとき、「どれがどれかわからない」問題に直面したことはないだろうか？

私もそうだった。3つのサブエージェントが走っていて、ステータスを確認するためにチャットを開いたり閉じたり。地味にストレスだった。

そこで生まれたのが**MISO（Mission Inline Skill Orchestration）**。

## ダッシュボード疲れという問題

現代の開発現場では、Slack、Jira、GitHub、Trello…ツールは山積みだ。でも「進捗を見る」という一つの目的のために、いちいちダッシュボードを開くのは正直うんざり。

特にAIエージェントのマルチタスク実行では、リアルタイムのステータス更新が命だ。チャットを開かずに、チャットリストから一発でわかる状態にしたかった。

## 解決策：Telegramネイティブの4+1 Layer UX

そこで思いついたのが、Telegramの**リアクション機能**を活用したUIデザインだ。

### Layer 0: 📌 Pin（存在）
ミッション中だけチャット上部にピン留め。チャットを開いた瞬間に「今何が走ってるか」がわかる。

### Layer 0.5: 👀 ackReaction（受信）
メッセージを受け取った瞬間に👀リアクション。「受け取ったぞ」の最速フィードバック。返信後に自動削除。

### Layer 1: 🔥🎉❌ Reaction（状態）
チャットリストから開かずにステータスを識別。
- 🔥 実行中
- 👀 承認待ち
- 🎉 完了
- ❌ エラー

これが一番効く。開く必要がない。

### Layer 2: Message Body（詳細）
必要なときだけ開いて読む。プログレスバー、エージェントの思考（🧠）、コストなどを表示。

### Layer 3: Inline Buttons（アクション）
承認待ちのときにボタンで操作。「承認」「プレビュー」「修正」「中止」がワンタップ。

## OpenClawスキルとしての実装

MISOはOpenClawのスキルとして実装されている。Pythonコードはいらない。`SKILL.md`にパターンを書くだけで、エージェントが自動的に従ってくれる。

### テンプレート駆動
各フェーズ（INIT → RUNNING → PARTIAL → AWAITING APPROVAL → COMPLETE）で定型メッセージを送信・編集。

### リアクション自動化
フェーズ遷移時に自動で🔥→👀→🎉のリアクション切り替え。

### Pinの自動管理
開始時にピン、完了時にアンピン。手動いらず。

### GIF統合（v1.6）
Phase 2/3でアニメーションGIFを使って、より直感的なプログレス表示を実現。

## 実際の使用例

例：コンペティティブ分析ミッション

```
🤖 𝗠𝗜𝗦𝗦𝗜𝗢𝗡 𝗖𝗢𝗡𝗧𝗥𝗢𝗟
——————————————
📋 PPAL競合分析
⏱ 2m 30s ∣ 💰 $0.15

↳ 🧩 AGENTS (2/5 complete)
——————————————

✅ リサーチャー ∣ 市場調査
▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓ 100%
🧠 3社のデータ収集完了

🔥 ライター ∣ レポート作成
▓▓▓▓▓▓▓░░░░░░░░ 50%
🧠 構成案作成中

——————————————
🌸 ᴘᴏᴡᴇʀᴇᴅ ʙʏ ᴍɪʏᴀʙɪ
```

チャットリストから🔥が見えるだけで「あ、動いてる」とわかる。

## これからできること

### マルチミッション対応
複数ミッションが同時に走っても、Master Ticketで一覧表示。
```
📌 𝗠𝗜𝗦𝗢 𝗗𝗔𝗦𝗛𝗕𝗢𝗔𝗥𝗗
——————————————
1️⃣ 🔥 PPAL分析 (3/5)
2️⃣ 👀 note記事 — 承認待ち
3️⃣ ✅ KAEDE調査 — 完了済み
——————————————
今日: 3ミッション ∣ 💰 $0.45
```

### チャネル自動投稿
ミッション開始・完了時に自動で@MIYABI_CHANNELに通知。チーム全員が進捗を把握。

## まとめ

MISOは「ダッシュボードを開く」という作業を「チャットリストを見る」という作業に置き換えた。

開く手間を省く。それが生産性だ。

---

**🌸 ᴘᴏᴡᴇʀᴇᴅ ʙʏ ᴍɪʏᴀʙɪ**

---

### 関連リンク
- [MISO GitHub](https://github.com/ShunsukeHayashi/miso)
- [OpenClaw Docs](https://docs.openclaw.ai)
- [Ambitious AI](https://hayashi-shunsuke.com/)

### サポート
この記事が気に入ったら：
- [メンバーシップ登録](https://note.com/ambitiousai/membership)
- [Xでフォロー](https://x.com/The_AGI_WAY)
- [GitHubでスター](https://github.com/ShunsukeHayashi/miso/stargazers)

---

\#MISO #OpenClaw #AI #Telegram #開発
