# Changelog

All notable changes to the MintGarden skill will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2026-01-29

### Added
- Initial release
- Complete MintGarden API wrapper (40+ endpoints)
- CLI commands via `mg` and `mintgarden`
- Telegram integration with `/mg` command
- Natural language command parsing
- Search functionality (NFTs, collections, global)
- Collection browsing and statistics
- NFT details, history, and offers
- Profile lookup and portfolio tracking
- Event monitoring and activity feeds
- Trending collections and top traders/collectors
- Global marketplace statistics
- Pagination support
- Error handling and user-friendly messages
- Formatted output for CLI and messaging platforms
- API client for programmatic access
- ClawdHub package structure
- Comprehensive documentation (SKILL.md, README.md)
- Installation script
- MIT License

### Features
- 🔍 Search: Universal, NFT-specific, and collection-specific search
- 📊 Stats: Floor prices, volumes, sales, global statistics
- 🖼️ NFTs: Details, attributes, rarity, ownership, trade history
- 📚 Collections: Browse, filter, sort, view activity
- 👤 Profiles: User portfolios, holdings, activity
- 📈 Events: Real-time marketplace activity monitoring
- 💰 Offers: Active bids and listings
- 🔥 Trending: 24-hour trending collections
- ⚡ Shortcuts: Direct ID/DID lookups

### Technical
- Node.js 18+ compatibility
- Axios for HTTP requests
- 30-second timeout for API calls
- Graceful error handling
- No API key required
- Production-ready code

## [Unreleased]

### Planned
- Image preview support (fetch NFT images)
- Price alerts and notifications
- Collection comparison tools
- Portfolio value tracking
- Rarity calculator
- Offer recommendation engine
- Historical price charts
- Export data to CSV/JSON
- Webhook support for real-time events
- Custom API base URL configuration
- Rate limiting and caching
- GraphQL query builder
- Batch operations
- Advanced filtering options

---

[1.0.0]: https://github.com/yourusername/mintgarden-skill/releases/tag/v1.0.0
