# Mini-Agent 快速入门指南

## 什么是 Mini-Agent？

Mini-Agent 是基于 MiniMax M2.5 大模型的智能助手，专门为 OpenClaw Agent 系统打造。它能够理解你的自然语言指令，帮你完成文件操作、代码编写、系统管理等任务。

## 5 分钟快速上手

### 步骤 1: 了解基本能力

Mini-Agent 可以帮你：

- 📝 读写文件和代码
- 💻 执行系统命令
- 🔧 编写和修复代码
- 📊 分析和处理数据
- 🚀 启动和管理服务

### 步骤 2: 发送你的第一个任务

简单直接地描述你的需求：

```
"读取当前目录下的 README.md 文件"
```

或

```
"帮我写一个 Hello World Python 脚本"
```

### 步骤 3: 观察执行过程

Mini-Agent 会：
1. 理解你的需求
2. 选择合适的工具执行
3. 报告执行结果
4. 询问是否需要进一步操作

## 常用命令模式

### 文件操作
```
"读取 /path/to/file.txt"
"创建一个新文件 example.txt"
"修改 config.yaml 中的某个配置"
```

### 代码开发
```
"写一个 Python 函数处理数组"
"帮我检查这段代码的 Bug"
"给这个函数添加单元测试"
```

### 系统管理
```
"查看当前目录的文件列表"
"启动一个 HTTP 服务器"
"检查某个服务的运行状态"
```

## 进阶技巧

### 1. 分步执行复杂任务

❌ 不要：
```
"帮我创建一个完整的博客系统"
```

✅ 应该：
```
"1. 先创建一个项目目录结构
2. 然后创建 requirements.txt
3. 再创建主程序 app.py"
```

### 2. 指定具体格式

❌ 不要：
```
"输出一些数据"
```

✅ 应该：
```
"输出为 CSV 格式，包含 name, age, email 三列"
```

### 3. 说明约束条件

```
"用 Python 3 编写，不要使用外部库"
"修改后保持代码风格一致"
"只修改指定的文件，不要动其他文件"
```

## 下一步

- 阅读 [配置指南](./CONFIG.md) 了解如何定制 Mini-Agent
- 查看 [使用示例](./EXAMPLES.md) 学习更多技巧
- 参考 [SKILL.md](./SKILL.md) 了解完整功能
