# Horoscope Prompt Template

## agentTurn Message (Daily Cron)

```
Generate a personalized daily horoscope for {user_name}.

Step 1: Read birth data
- memory_search "horoscope {user_name}"
- Extract: western sign, Ba-Zi chart, day master, five elements, telegram chat ID

Step 2: Get planetary data
- Run: python3 .claude/skills/daily-horoscope/scripts/fetch-planetary-positions.py --lat {lat} --lon {lon}
- If script fails, skip transit section and use general zodiac knowledge only

Step 3: Calculate today's Ba-Zi
- Run: python3 .claude/skills/daily-horoscope/scripts/calculate-bazi.py --date {today} --time 12:00 --tz "{tz}"
- Extract today's day pillar for interaction analysis

Step 4: Compose horoscope using this format:

---
{zodiac_emoji} {Western_Sign} Daily Horoscope — {user_name}
{formatted_date}

**Sun Sign Reading**
[3-4 sentences about {western_sign} today. Reference specific planet transits from Step 2. Focus on the most impactful transit for this sign. Be specific, not vague.]

**Ba-Zi / Bat Tu Daily Analysis**
Day Master: {day_master_viet} ({element}, {polarity})
Today's Pillar: {today_stem_viet} {today_branch_viet} ({element} {animal})
Element Flow: [Explain if today's elements generate (tuong sinh) or destroy (tuong khac) the Day Master]
Branch Relation: [Check natal branches vs today's branch for harmony (hop), clash (xung), or punishment (hinh)]
Advice: [1 sentence practical advice based on element interaction]

**Key Transits**
[List 2-3 most significant aspects from planetary data]
- {Planet1} {aspect} {Planet2}: {1-sentence meaning}

**Moon in {sign} ({phase})**
[1-2 sentences emotional/intuitive guidance based on moon sign and phase]

Lucky: {color} | {number} | {element_to_favor}
---

Step 5: Send via telegram_actions to {chat_id}

IMPORTANT:
- Use ONLY the planetary data provided by the script. Do not invent positions.
- Keep total length 150-250 words.
- Tone: warm, insightful, practical. Not vague fortune-cookie style.
- Include both Vietnamese and English terms for Ba-Zi concepts.
```

## Fallback Prompt (No API Data)

```
Generate a personalized daily horoscope for {user_name}.

Step 1: Read birth data from memory (memory_search "horoscope {user_name}")
Step 2: planetary script unavailable today. Skip specific transits.
Step 3: Calculate today's Ba-Zi pillar.

Compose horoscope using general zodiac knowledge for {western_sign}.
Focus on Ba-Zi analysis (Day Master interaction with today's pillar).
Omit "Key Transits" section. Keep other sections.
Note at bottom: "Transit data unavailable today — general reading."
```

## Variable Substitution

| Variable | Source | Example |
|----------|--------|---------|
| `{user_name}` | Memory file | "Hieu" |
| `{western_sign}` | Memory file | "Taurus" |
| `{day_master_viet}` | Memory file | "Canh" |
| `{lat}`, `{lon}` | Birth city coords | 10.82, 106.63 |
| `{tz}` | Memory file | "Asia/Saigon" |
| `{chat_id}` | Memory file | "-100123456789" |
| `{today}` | Runtime | "2026-02-02" |
| `{formatted_date}` | Runtime | "Sunday, February 2, 2026" |

## Zodiac Emoji Map

Aries: ram, Taurus: bull, Gemini: twins, Cancer: crab, Leo: lion, Virgo: woman,
Libra: scales, Scorpio: scorpion, Sagittarius: bow, Capricorn: goat, Aquarius: water,
Pisces: fish
