# AstronomyAPI Reference

**Base URL:** `https://api.astronomyapi.com`
**Auth:** Basic Auth — `base64(applicationId:applicationSecret)`
**Env vars:** `ASTRONOMY_APP_ID`, `ASTRONOMY_APP_SECRET`

## Endpoints

### Planetary Positions
`GET /api/v2/bodies/positions`

Params: `latitude`, `longitude`, `elevation`, `from_date`, `to_date`, `time`

Returns: ecliptic longitude/latitude, RA/Dec, distance for each body.

### Single Body
`GET /api/v2/bodies/positions/:body`

Same params; returns single body in tabular format.

### Moon Phase
`POST /api/v2/studio/moon-phase`

Body: `{ "format": "png", "style": { "moonStyle": "sketch", "backgroundStyle": "stars" }, "observer": { "latitude": N, "longitude": N } }`

Returns: moon phase image URL.

## Bodies Available

Sun, Moon, Mercury, Venus, Mars, Jupiter, Saturn, Uranus, Neptune, Pluto

## Rate Limits

- Free tier, IP-based limits
- 429 on excess — retry with backoff
- Daily single-call pattern well within limits

## Notes

- Returns **astronomical** data, not astrological
- Zodiac sign calculation done locally from ecliptic longitude
- Retrograde detection: compare today vs yesterday longitude
- Aspect detection: calculate angular separation between planets
