# MindGraph — The Brain Analogy 🧠

MindGraph mirrors how a human brain works:

| Brain | MindGraph |
|-------|-----------|
| Neurons | Nodes (concepts, files, people, projects) |
| Synapses | `[[wikilinks]]` (connections between nodes) |
| Learned procedures (muscle memory) | MindSkills (Knockout Test, SEO Validator...) |
| Associative recall | Backlinks — "Drift" triggers → LeadPilot → Knockout Test → B2B SaaS |
| Weak/fading memories | Orphan nodes (no connections = useless) |
| Strong neural pathways | Most-referenced nodes (frequently linked = core concepts) |
| Learning | `mindgraph.py learn` — teach new repeatable processes |
| Recall | `mindgraph.py query` — pull everything connected to a topic |

**The more you use a connection, the stronger it gets.** Every time `[[LeadPilot]]` appears in a new file, that node gets richer, more connected, easier to find.

**Unlike a human brain:** These synapses don't decay. The agent wakes up fresh every session, but the graph remembers everything. Persistent memory through structure, not biology.

**MindSkills are muscle memory.** You don't re-learn how to ride a bike. Once the Knockout Test is learned, the process is encoded — just say "knockout test this" and it executes. Learn an SEO Validator, a Competitor Analysis, a Tech Stack Review — each one is a new capability permanently wired into the system.

The result: a modular AI brain that grows smarter with every interaction.
