# [[Knockout Test]] 🥊

Idea validation framework. A structured sparring match against a business idea to decide: BUILD, PIVOT, or PARK.

## Trigger Phrases

- "Run a knockout test on X"
- "Knockout test this idea"
- "Should I build X?"
- "Validate this idea"
- "Is this worth building?"

## Process

### Round 1: Build It Up 💪
Be the optimist. Make the strongest case FOR the idea:
- **The pain**: What problem does this solve? How badly does it hurt?
- **The market**: How big? Who are the buyers? TAM/SAM?
- **The money**: Revenue model, pricing, willingness to pay
- **Why now**: What changed that makes this possible/needed today?
- **The hook**: One sentence that sells it

### Round 2: Tear It Down 👊
Be the pessimist. Attack every weakness:
- **Competition**: Who already does this? How established?
- **Challenges**: What's technically hard? What could break?
- **Why it fails**: The most likely death scenario
- **Barriers**: Trust, regulation, chicken-and-egg, data moats

### Round 3: Reality Check 🧐
Be the realist. Strip away the hype:
- **Feature vs Product**: Is this a feature of something bigger or a standalone business?
- **Who pays**: Actually pays, not "would be nice to have"
- **Distribution**: How do you get in front of buyers? SEO, ads, partnerships?
- **Differentiation**: What's the moat? Why can't someone copy this in a weekend?
- **Unit economics**: CAC vs LTV, margins, scale dynamics

### Round 4: Verdict 🏆
One of three outcomes:
- **✅ BUILD** — Clear market, real pain, viable economics, go ship it
- **🟡 PIVOT** — Core insight is good but execution angle needs to change
- **🅿️ PARK** — Not now. Document why and what would change your mind

## Output Format

Each result includes:
- Full analysis per round with `[[wikilinks]]` to competitors, markets, related projects
- Clear verdict with reasoning
- "What would change my mind" section for PIVOT/PARK verdicts
- Connected projects and ideas

## Scoring Signals

Strong BUILD indicators:
- Personal pain (founder uses it themselves)
- Existing market with overpriced incumbents
- Clear distribution channel
- Quick to MVP (<4 weeks)
- Measurable ROI for buyer

Strong PARK indicators:
- Well-funded competitors with product-market fit
- It's a feature, not a product
- "Would be nice" but nobody pays
- Requires massive scale to work
- Regulatory minefield
