#!/bin/bash
# MindGraph Server Start Script

SCRIPTS_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SKILL_ROOT="$(cd "$SCRIPTS_DIR/.." && pwd)"
DATA_DIR="$SKILL_ROOT/data"

mkdir -p "$DATA_DIR"

# Load config if exists
CONFIG_PATH="$DATA_DIR/mindgraph.json"
if [ -f "$CONFIG_PATH" ]; then
  TOKEN=$(python3 -c "import json; print(json.load(open('$CONFIG_PATH'))['token'])")
  PORT=$(python3 -c "import json; print(json.load(open('$CONFIG_PATH'))['port'])")
else
  # Generate defaults
  TOKEN=$(head /dev/urandom | tr -dc A-Za-z0-9 | head -c 32)
  PORT=18790
  echo "{\"token\": \"$TOKEN\", \"port\": $PORT}" > "$CONFIG_PATH"
fi

export MINDGRAPH_TOKEN=${MINDGRAPH_TOKEN:-$TOKEN}
export MINDGRAPH_PORT=${MINDGRAPH_PORT:-$PORT}
export MINDGRAPH_DB_PATH="${MINDGRAPH_DB_PATH:-$DATA_DIR/mindgraph.db}"

echo "🧠 Starting MindGraph Server on port $MINDGRAPH_PORT..."
"$SCRIPTS_DIR/mindgraph-server"
