# Practice Modes - Mindfulness

Use one active mode at a time unless the user explicitly asks to combine.

| Mode | Use when | Primary output | Success signal |
|------|----------|----------------|----------------|
| `logger` | User wants tracking only | consistent session logging | complete logs for 7+ days |
| `guided` | User asks for live step-by-step meditation | guided session script | completed session with post reflection |
| `builder` | User wants routine growth and consistency | progressive weekly plan | target adherence >= 70 percent |
| `reset` | User is acutely stressed and needs immediate support | 1 to 3 minute downshift protocol | immediate state reduction and stabilization |

## Switching Rules

- Start in `logger` if context is unclear.
- Switch to `guided` when user asks for a live practice now.
- Switch to `builder` after at least 3 logged sessions and user interest in consistency.
- Use `reset` only for high-stress moments, then return to the prior mode.

## Escalation Rule

If distress is severe, escalating, or safety-sensitive, stop routine coaching and direct professional or emergency support.
