const fs = require('fs-extra');
const path = require('path');

const TEST_DIR = path.join(__dirname, '../test-data');
const CONFIG_PATH = path.join(TEST_DIR, '.openclaw/openclaw.json');
const MEMORY_PATH = path.join(TEST_DIR, 'clawd/MEMORY.md');

async function generateMock() {
  await fs.ensureDir(path.dirname(CONFIG_PATH));
  await fs.ensureDir(path.dirname(MEMORY_PATH));

  const mockConfig = {
    "auth": {
      "profiles": {
        "openai:default": {
          "provider": "openai",
          "mode": "api_key",
          "apiKey": "mock-key-do-not-use-in-production" 
        }
      }
    },
    "agents": {
      "defaults": {
        "workspace": "/Users/mockuser/clawd"
      }
    }
  };

  const mockMemory = "# Memory\n\nThis is a mock memory file for testing migration.\n";

  await fs.writeJson(CONFIG_PATH, mockConfig, { spaces: 2 });
  await fs.writeFile(MEMORY_PATH, mockMemory);

  console.log(`✅ Mock data generated at ${TEST_DIR}`);
}

generateMock().catch(console.error);
