---
name: micro-offer-forge
description: Convert a workflow, skill, or capability into a sellable micro-offer with positioning, pricing, packaging, and launch assets.
---

# Micro Offer Forge

Use this skill to package something small but useful into a product people will pay for quickly.

## Inputs
- Capability/workflow (what is being sold)
- Audience/niche
- Pain solved
- Delivery format (doc, template, script, audit, mini-service)

## Process
1. Define the **outcome promise** in one sentence.
2. Select buyer persona + purchase trigger.
3. Build offer stack:
   - core deliverable
   - bonus(s)
   - turnaround/format
4. Price ladder:
   - entry price
   - standard
   - premium/add-on
5. Risk reducer:
   - guarantee, preview, sample, or proof
6. Launch assets:
   - landing copy draft
   - 5 post ideas
   - 3 DM/outreach lines

## Output format
- Offer one-liner
- Who buys and why now
- Deliverables list
- Pricing table
- Objection handling bullets
- 7-day launch checklist

## Constraints
- Avoid vague outcomes
- Keep scope small enough for fast delivery
- Focus on one painful problem only
- Make first version shippable in <=48h

## Example
"Turn a Reddit research workflow into a €19 downloadable playbook + €99 done-with-you setup add-on."