# Miami Transportation

## Reality Check: You Need a Car

**Miami is a car city.** Unlike NYC or Chicago, public transit is limited and distances are far.

| Lifestyle | Car Needed? |
|-----------|-------------|
| Live + work in Brickell | Maybe not (but limiting) |
| Live in SoBe, never leave beach | Probably not |
| Normal Miami life | YES, absolutely |
| Visiting for a week | Uber works |

---

## Driving in Miami

### What to Expect
- **Aggressive drivers:** Faster and more aggressive than most US cities
- **Turn signals:** Optional apparently (stay alert)
- **Traffic:** I-95 is brutal, Brickell Ave crawls
- **Parking:** Expensive everywhere ($20-50/day downtown/beach)

### Rush Hour
| Direction | Bad Times | Avoid |
|-----------|-----------|-------|
| **Into downtown** | 7-9am | I-95 south, I-395 |
| **Out of downtown** | 4-7pm | I-95 north, 836 west |
| **To beach** | Fri 4-8pm | Causeway jammed |
| **From beach** | Sun 4-7pm | Everyone leaving |

### Tolls
Miami has LOTS of tolls:
- **SunPass:** Get one immediately (sticker or portable)
- **Toll-by-Plate:** Works but costs more
- Express lanes on I-95 (prices vary by congestion)
- Airport area has many tolls

---

## Parking

### Street Parking
| Area | Rate | Payment |
|------|------|---------|
| South Beach | $4-6/hour | PayByPhone app |
| Brickell | $2-4/hour | Meters or app |
| Wynwood | $3-5/hour | Limited meters |
| Coral Gables | Often free | 2-hour limits |

### Garages
| Area | Daily Rate |
|------|------------|
| South Beach | $20-40 |
| Brickell | $20-35 |
| Downtown | $15-25 |
| Airport | $17/day (garage) |

### Tips
- **PayByPhone app:** Works for most Miami Beach meters
- **Residential permits:** Available if you live in permit zones
- **Read signs carefully:** Towing is aggressive and fast

---

## Public Transit

### Metrorail
- **One elevated line** (like a single subway line)
- Runs: Airport → Downtown → South Miami → Dadeland
- Useful for: Airport to downtown, Brickell to Coral Gables
- Not useful for: Beach, Wynwood, most places
- Fare: $2.25

### Metromover
- **FREE** automated people mover
- Downtown/Brickell loop only
- Actually useful within its limited area
- Connects to Metrorail

### Metrobus
- Extensive but slow
- Useful routes: Beach to downtown, Brickell to Grove
- Most tourists/residents don't use it
- Fare: $2.25

### Brightline (Train)
- High-speed train: Miami ↔ Fort Lauderdale ↔ West Palm Beach ↔ Orlando
- MiamiCentral station downtown
- $15-30 to Fort Lauderdale (30 min)
- $79-199 to Orlando (3.5 hours)
- Good for: Airport connections, day trips

---

## Rideshare

### Uber/Lyft Pricing
| Route | Typical Cost |
|-------|--------------|
| SoBe to Brickell | $15-25 |
| Brickell to Wynwood | $12-18 |
| Airport to SoBe | $25-40 |
| Airport to Brickell | $20-30 |
| Downtown to Coral Gables | $15-25 |

### Surge Pricing
- Friday/Saturday nights: 2-3x normal
- After events (Heat games, concerts): Brutal
- Rain: Immediate surge
- Art Basel week: Insane

### Tips
- Schedule rides in advance for airport
- Walk a block away from venues for better pricing
- Lyft often slightly cheaper than Uber

---

## Bikes & Scooters

### Citi Bike
- Blue bikes, stations throughout
- $6/30-min ride, $25/month unlimited
- Good for: SoBe, Brickell, short trips
- Not good for: Distances, Miami heat

### Electric Scooters
- Various brands (Lime, Bird, etc.)
- Available in beach, Brickell, Wynwood
- ~$1 to start + $0.30/min
- Helmet not required but recommended

### Biking Reality
- Bike infrastructure is improving but still limited
- Drivers don't respect bike lanes
- Summer heat makes biking rough
- Electric bikes increasingly popular

---

## Airport (MIA)

### Getting There
| From | Method | Time | Cost |
|------|--------|------|------|
| Brickell | Metrorail | 20 min | $2.25 |
| South Beach | Uber/Lyft | 25-40 min | $25-40 |
| Downtown | Metrorail | 15 min | $2.25 |
| Coral Gables | Uber/Lyft | 15-20 min | $15-25 |

### MIA Tips
- **Pre-check/Global Entry:** Worth it, lines are long
- **Terminal layout:** One big U-shape
- **Food options:** Decent, prices reasonable for airport
- **Miami Metrorail:** Connects directly (cheap option)

### Parking at MIA
| Option | Daily Rate |
|--------|------------|
| Garage (closest) | $17 |
| Economy | $10 |
| Off-site lots | $8-12 |
