# Miami Tech Scene

## Overview

Miami tech exploded in 2020-2021 with high-profile moves (Founders Fund, Keith Rabois) and has matured into a real but small ecosystem.

### The Reality
- **Smaller than SF/NYC/Austin** — but growing
- **Fintech and crypto heavy** — that's the strength
- **LatAm gateway** — unique positioning
- **Remote-friendly** — many "Miami" companies are distributed
- **Younger scene** — still finding its identity

---

## Major Companies & Offices

### Tech Giants with Miami Presence
| Company | Office | Focus |
|---------|--------|-------|
| **Microsoft** | Brickell | Sales, cloud |
| **Google** | None (remote workers) | — |
| **Meta** | None (remote workers) | — |
| **Amazon** | Multiple | AWS, logistics |
| **Spotify** | Remote hub | — |

### Fintech/Crypto HQs
| Company | Area | Focus |
|---------|------|-------|
| **Blockchain.com** | Brickell | Crypto exchange |
| **FTX** | (was Brickell) | Defunct |
| **Pipe** | Miami Beach | Revenue financing |
| **Dapper Labs** | Remote/Miami | NFTs, Flow blockchain |
| **Circle** | Miami presence | USDC stablecoin |

### Notable Miami-Founded Startups
| Company | Focus | Raised |
|---------|-------|--------|
| **Pipe** | Revenue financing | $300M+ |
| **Reef Technology** | Ghost kitchens | $1B+ |
| **Neocis** | Dental robotics | $200M+ |
| **Papa** | Elder care | $200M+ |
| **Caribu** | Kids video calls | $50M+ |

---

## Where Tech People Work

### Coworking Spaces
| Space | Area | Vibe | Price |
|-------|------|------|-------|
| **WeWork** | Multiple | Corporate | $500-800/mo |
| **Lab Miami** | Wynwood | Startup-y | $300-500/mo |
| **Büro** | Brickell | Professional | $400-600/mo |
| **Pipeline** | Brickell | Startup-focused | $350-500/mo |
| **Spaces** | Brickell, SoBe | Regus brand | $400-600/mo |

### Coffee Shops for Remote Work
| Shop | Area | WiFi | Notes |
|------|------|------|-------|
| **Panther Coffee** | Multiple | Good | Can get crowded |
| **All Day** | Design District | Good | Trendy |
| **Blue Bottle** | Brickell | Good | Reliable |
| **Threefold** | Coral Gables | Good | Australian, excellent |

---

## Salary Expectations

### Tech Salaries (2024-2025)
| Role | Miami Range | vs SF |
|------|-------------|-------|
| **Junior Software Engineer** | $80-110K | -20-30% |
| **Senior Software Engineer** | $140-180K | -15-25% |
| **Staff Engineer** | $180-250K | -20-30% |
| **Engineering Manager** | $180-230K | -15-25% |
| **Product Manager** | $130-180K | -15-25% |
| **Designer (Senior)** | $120-160K | -20-30% |
| **Data Scientist** | $130-180K | -15-25% |

### The Calculation
- Miami pays less than SF/NYC
- But no state income tax (+8-13%)
- And lower cost of living (somewhat)
- Net: Often comparable take-home

### Compensation Notes
- Remote SF salaries + Miami living = best deal
- Local companies pay Miami market rates
- Equity is less common than SF
- Bonuses more common in finance-adjacent

---

## Tech Community

### Events & Meetups
| Event | Frequency | Notes |
|-------|-----------|-------|
| **eMerge Americas** | Annual (April) | Main conference |
| **Refresh Miami** | Monthly | Largest meetup |
| **Miami Bitcoin** | Regular | Crypto community |
| **GDG Miami** | Monthly | Google Developers |
| **AWS User Group** | Monthly | Cloud focused |

### Online Communities
- **Refresh Miami Slack** — Most active
- **Miami Tech Twitter** — Keith Rabois, David Goldberg
- **Discord servers** — Various crypto/startup
- **LinkedIn** — Surprisingly active in Miami

### Key People to Follow
- **Keith Rabois** (Founders Fund)
- **David Goldberg** (Alpaca VC)
- **Nancy Dahlberg** (Miami tech journalist)
- **Melissa Medina** (eMerge Americas)

---

## Getting a Tech Job in Miami

### Job Boards
| Site | Focus |
|------|-------|
| **Refresh Miami** | Local startups |
| **LinkedIn** | Everything |
| **AngelList/Wellfound** | Startups |
| **Indeed** | Volume |
| **Built In Miami** | Tech focus |

### Tips
1. **Network in person** — Miami is relationship-driven
2. **Attend eMerge Americas** — Best for connections
3. **Consider remote** — Many "Miami" jobs are remote-first
4. **Fintech/crypto** — Strongest sectors
5. **LatAm connection** — Valuable if you have it

### Interview Culture
- More casual than NYC finance
- Less intense than SF startups
- Spanish can be an advantage
- Cultural fit matters a lot
