# Miami Startup Scene

## The Miami Startup Story

### 2020-2021: The Hype
- Founders Fund opened Miami office (Keith Rabois)
- "Miami Tech" became a thing
- Crypto money flooded in
- NYC/SF founders relocated during COVID
- Mayor Suarez became tech booster

### 2022-2024: Reality Check
- FTX collapse hurt crypto credibility
- Some hype faded, but real companies remained
- Focus shifted from hype to building
- Fintech/crypto still strongest sectors
- LatAm gateway angle solidified

### Current State (2025)
- Real but small ecosystem
- Fintech, crypto, LatAm focus
- Growing but not replacing SF/NYC
- Good for specific types of startups

---

## Funding Landscape

### VCs with Miami Presence
| Firm | Focus | Notes |
|------|-------|-------|
| **Founders Fund** | General | Keith Rabois |
| **Softbank** | LatAm focus | Miami office |
| **Andreessen Horowitz (a16z)** | Crypto | Miami presence |
| **Atomic** | Venture studio | Local |
| **500 Global (LatAm)** | Emerging markets | Strong LatAm |
| **TheVentureCity** | LatAm startups | Miami-based |

### Miami-Based Funds
| Fund | Focus | Check Size |
|------|-------|------------|
| **Fuel Venture Capital** | Early stage | $500K-2M |
| **Las Olas VC** | Consumer | $1-5M |
| **Building Ventures** | PropTech | $5-15M |
| **Starlight Ventures** | Early stage | $250K-1M |

### Reality Check
- Less capital available than SF/NYC
- Fintech/crypto gets most attention
- LatAm startups have advantage
- Many Miami startups raise from coastal VCs

---

## Startup Resources

### Accelerators & Incubators
| Program | Focus | Notes |
|---------|-------|-------|
| **Endeavor Miami** | Scale-ups | High-impact entrepreneurs |
| **Venture Hive** | Early stage | Cohort-based |
| **CIC Miami** | Innovation community | Cambridge Innovation Center |
| **The LAB Miami** | Wynwood hub | Coworking + community |
| **Babson WIN Lab** | Women founders | Support program |

### Key Organizations
| Organization | Purpose |
|--------------|---------|
| **Refresh Miami** | Largest tech community |
| **eMerge Americas** | Annual conference |
| **Miami Angels** | Angel investor group |
| **Endeavor Miami** | Scale-up support |
| **Knight Foundation** | Civic tech funding |

---

## Startup Costs

### Office Space
| Option | Cost | Notes |
|--------|------|-------|
| **Working from home** | $0 | Common early stage |
| **Coffee shop grinding** | $10/day | Many founders do this |
| **Coworking desk** | $300-500/mo | WeWork, Lab Miami |
| **Coworking office** | $800-2,000/mo | Small team |
| **Office lease** | $40-60/sqft/year | When you're funded |

### Startup Formation
| Cost | Amount |
|------|--------|
| **Delaware C-Corp** | $500-1,500 |
| **Lawyer (basic docs)** | $2,000-5,000 |
| **Accounting setup** | $500-1,000 |
| **Bank account** | $0 (Mercury, etc.) |

### Hiring Costs
| Role | Miami Salary | vs SF |
|------|--------------|-------|
| **First engineer** | $100-140K | -20% |
| **Designer** | $80-120K | -25% |
| **First sales** | $70-100K + commission | -15% |

---

## Startup-Friendly Things About Miami

### Advantages
✅ **No state income tax** — Founder equity worth more
✅ **Lower salaries** — Stretch runway further
✅ **LatAm gateway** — Access to talent and markets
✅ **Crypto-friendly** — Mayor and ecosystem support
✅ **Quality of life** — Easier to recruit for some people
✅ **Time zone** — Overlaps with NYC, LatAm, and some Europe

### Disadvantages
❌ **Smaller talent pool** — Hard to find senior engineers
❌ **Less capital** — Most big VCs still in SF/NYC
❌ **Network effects** — SF still has more density
❌ **Enterprise sales** — Most enterprises elsewhere
❌ **Distractions** — Beach, nightlife, lifestyle
❌ **Humidity** — Seriously, it's brutal

---

## Best Sectors for Miami Startups

### Where Miami Has Advantage
| Sector | Why |
|--------|-----|
| **Fintech** | Brickell finance hub, LatAm connections |
| **Crypto/Web3** | Mayor support, existing community |
| **LatAm startups** | Time zone, cultural bridge, talent |
| **Hospitality tech** | Tourism industry, hotels, restaurants |
| **Real estate tech** | Hot market, developer connections |
| **Healthtech** | Aging population, medical tourism |
| **Climate tech** | Sea level rise, hurricanes (real problems) |

### Where Miami Struggles
| Sector | Why |
|--------|-----|
| **Deep tech** | Limited research institutions |
| **Enterprise SaaS** | Customers elsewhere |
| **Hardware** | Manufacturing elsewhere |
| **Biotech** | Research happens elsewhere |

---

## Networking

### Events to Attend
| Event | Frequency | Best For |
|-------|-----------|----------|
| **Refresh Miami** | Monthly | General networking |
| **eMerge Americas** | Annual (April) | Best conference |
| **Miami Tech Week** | Annual | Multiple events |
| **Founders' Friday** | Weekly | Casual meetup |

### Where Founders Hang Out
- **The LAB Miami** — Wynwood, startup-y
- **CIC Miami** — Formal, investor meetings
- **Panther Coffee** — Casual meetings
- **Brickell rooftops** — After-work drinks

### Building Relationships
1. **Show up consistently** — Same events, same people
2. **Help before asking** — Miami is relationship-driven
3. **Twitter/X** — Miami tech Twitter is active
4. **Founders dinners** — Get invited, host your own
5. **Sports** — Golf, tennis, padel (common bonding)

---

## Should You Start a Company in Miami?

### Yes If:
- Building fintech, crypto, or LatAm-focused
- Want lower burn rate than SF
- Have personal connections here
- Lifestyle matters to you
- Targeting hospitality, real estate, or climate

### Maybe Not If:
- Need deep senior engineering talent immediately
- Building enterprise SaaS (customers in SF/NYC)
- Need lots of VC meetings (most still in SF)
- Want maximum network effects

### The Remote Option
Many founders "live in Miami, raise in SF, hire remote" — best of all worlds for some.
