# Miami Safety Guide

## Hurricane Preparedness

### Hurricane Season
- **Official season:** June 1 - November 30
- **Peak activity:** August - October
- **Reality:** Plan for it, but most seasons pass without direct hit

### Hurricane Categories
| Category | Wind Speed | Damage | Action |
|----------|------------|--------|--------|
| 1 | 74-95 mph | Minimal | Shelter in place |
| 2 | 96-110 mph | Moderate | Shelter in place |
| 3 | 111-129 mph | Extensive | Consider evacuation |
| 4 | 130-156 mph | Catastrophic | Evacuate if ordered |
| 5 | 157+ mph | Catastrophic | Evacuate if ordered |

### Hurricane Kit (Essential)
| Item | Quantity | Notes |
|------|----------|-------|
| Water | 1 gallon/person/day × 7 days | Most important |
| Non-perishable food | 7 days supply | Canned goods, crackers |
| Flashlights | 2+ | With extra batteries |
| Battery/crank radio | 1 | NOAA weather radio |
| First aid kit | 1 | Full kit |
| Cash | $200-500 | ATMs won't work |
| Phone chargers | Battery packs | Power banks |
| Medications | 7+ day supply | Critical |
| Important documents | Copies in waterproof bag | ID, insurance, lease |
| Pet supplies | If applicable | Food, carrier, meds |

### Evacuation Zones
Miami-Dade has evacuation zones A-E:
- **Zone A:** Barrier islands, coastal areas — evacuate first
- **Zone B:** Low-lying areas near water
- **Zone C-E:** Progressively further inland

**Know your zone:** miamidade.gov/emergency

### During Hurricane Season
1. **Know your zone** (look up your address)
2. **Know where to go** (inland hotel, friend's house, shelter)
3. **Have supplies ready** before storm approaches
4. **Keep gas tank full** during season (lines form fast)
5. **Have cash** (power outages = no ATMs)

---

## Crime & Safety

### Safe Areas
- **Brickell:** Very safe, well-policed
- **Coral Gables:** Safe, quiet residential
- **Key Biscayne:** Very safe, island community
- **Coconut Grove:** Generally safe
- **South Beach:** Safe but watch for petty theft

### Areas to Be Cautious
| Area | Notes |
|------|-------|
| **Overtown** | Improving but still high crime |
| **Liberty City** | Avoid, especially at night |
| **Little Haiti** | Gentrifying, mixed blocks |
| **Downtown at night** | Empty, can feel unsafe |
| **Wynwood late night** | Some blocks get sketchy |

### Common Crimes
| Crime | Where | Prevention |
|-------|-------|------------|
| Car break-ins | Everywhere | Never leave valuables visible |
| Phone snatching | Ocean Drive, tourist areas | Awareness, don't flash phone |
| Rental car theft | Tourist areas | Don't use obviously rental cars |
| Package theft | Residential | Concierge, Amazon Locker |
| Catalytic converter theft | Parking lots | Park in well-lit areas |

### Tips
- Don't leave ANYTHING visible in your car
- Use valet or garages in tourist areas
- Be aware of surroundings at ATMs
- Don't walk alone in poorly-lit areas late night
- Tourist areas have police presence (generally safe)

---

## Beach Safety

### Ocean Hazards
| Hazard | When | What to Do |
|--------|------|------------|
| **Rip currents** | After storms, any time | Swim parallel to shore |
| **Jellyfish** | Summer months | Lifeguard stations have vinegar |
| **Stingrays** | Year-round in shallows | Shuffle feet when entering |
| **Sharks** | Rare but present | Don't swim at dawn/dusk |

### Lifeguard Flags
| Flag | Meaning |
|------|---------|
| 🟢 Green | Calm conditions |
| 🟡 Yellow | Moderate hazard, caution |
| 🔴 Red | High hazard, strong currents |
| 🔴🔴 Double red | Water closed |
| 🟣 Purple | Dangerous marine life (jellyfish) |

### Sun Safety
- **UV index:** Often 10-11 (extreme)
- **Sunscreen:** SPF 30+, reapply every 2 hours
- **Peak hours:** 10am-4pm most intense
- **Hydration:** Drink water constantly
- **Heat exhaustion:** Real risk, take breaks in shade

---

## Driving Safety

### Miami Driving Reality
- Aggressive drivers are the norm
- Assume nobody will use turn signals
- Expect people to run red lights (count to 3 before going)
- Keep distance (tailgating is common)

### Flood Driving
- **Never drive through standing water** (can't judge depth)
- Underpasses flood quickly
- "Turn around, don't drown" is real
- After storms, roads may be impassable

### Scooter/Bike Safety
- Wear helmet (not required but smart)
- Ride with traffic, not against
- Assume cars don't see you
- Avoid riding at night in low-visibility areas

---

## Emergency Numbers

| Emergency | Number |
|-----------|--------|
| **Emergency** | 911 |
| **Police (non-emergency)** | 305-579-6111 |
| **Hurricane hotline** | 311 |
| **FPL outages** | 1-800-468-8243 |
| **Poison control** | 1-800-222-1222 |

### Apps to Have
- **Miami-Dade Emergency** — Official alerts
- **NOAA Weather** — Hurricane tracking
- **Citizen** — Local crime alerts
- **Waze** — Real-time traffic, flood reports
