# Moving to Miami - Resident Guide

## Before You Move

### Documents Needed
| Document | Why | Where to Get |
|----------|-----|--------------|
| **Florida Driver's License** | Required within 30 days | Any DMV, bring passport + proof of address |
| **Vehicle Registration** | Required within 10 days | DMV, bring title + insurance |
| **Voter Registration** | If you want to vote | Online or DMV |

### No State Income Tax
Florida has **no state income tax**. This is real money saved:
- California equivalent salary needs ~13% more to match
- New York equivalent needs ~10% more
- Keep more of what you earn

### But Watch Out For
- **Property taxes:** High (1.5-2% of home value)
- **Insurance costs:** Hurricane insurance expensive
- **Car insurance:** Higher than national average
- **HOA fees:** Common, can be $300-1500/month

---

## First Month Checklist

### Week 1
- [ ] Get Florida driver's license (DMV appointment)
- [ ] Register car in Florida
- [ ] Set up utilities (FPL for electric)
- [ ] Get renter's/home insurance
- [ ] Find primary care doctor
- [ ] Set up internet (Xfinity, AT&T Fiber)

### Week 2-4
- [ ] Explore neighborhoods
- [ ] Find your grocery store (Publix is Florida's king)
- [ ] Locate nearest urgent care
- [ ] Get hurricane supplies (see safety guide)
- [ ] Find your gym
- [ ] Set up bank (if changing)

---

## Utilities

### Electric (FPL - Florida Power & Light)
- Monopoly in Miami-Dade
- Summer bills HIGH ($200-400/month with AC)
- Budget billing available to even out costs
- Smart meters standard

### Internet
| Provider | Speed | Price | Notes |
|----------|-------|-------|-------|
| **AT&T Fiber** | Up to 5Gbps | $55-180 | Best if available |
| **Xfinity** | Up to 1.2Gbps | $50-100 | Most common |
| **Starlink** | 50-200Mbps | $120 | For rural areas |

### Water
- Miami-Dade Water & Sewer
- Relatively cheap ($30-60/month)
- Water is safe to drink (tastes fine)

---

## Healthcare

### Finding Doctors
- **Baptist Health:** Major system, good network
- **UHealth/Jackson:** University of Miami system, trauma center
- **Cleveland Clinic Florida:** Excellent, Weston location
- **Mount Sinai:** Miami Beach

### Insurance Notes
- ACA marketplace: healthcare.gov (open enrollment Nov-Jan)
- Many employers use Florida Blue or Aetna
- Urgent cares everywhere (CVS MinuteClinic, MD Now)

### Emergency Rooms
| Hospital | Area | Notes |
|----------|------|-------|
| Jackson Memorial | Downtown | Trauma center, busy |
| Mount Sinai | Miami Beach | Beach area |
| Baptist | Multiple | Good network |
| Mercy | Coconut Grove | Smaller, less wait |

---

## Banking

### Local Options
- **Regions:** Strong Florida presence
- **Truist:** Regional, good service
- **Valley National:** Smaller, local feel
- **Wells Fargo/Chase/BofA:** National, everywhere

### Tips
- Many people keep accounts from previous state
- Mobile banking makes location less relevant
- Some credit unions offer better rates

---

## Pets

### Dog-Friendly Miami
- Many apartment buildings allow dogs (with deposit/fee)
- Dog parks in most neighborhoods
- Beach: Haulover has dog beach area
- Restaurants often have outdoor patios allowing dogs

### Vet Care
- Emergency: Knowles Animal Hospital (24h)
- Many neighborhood vets
- Pet insurance recommended (Lemonade, Healthy Paws)

### Watch Out For
- **Heat:** Don't walk dogs on hot pavement (burns paws)
- **Bufo toads:** Toxic, especially during summer rains
- **Heartworm:** Year-round prevention needed (mosquitoes)

---

## Mail & Packages

### Package Theft
- Real problem in some areas
- Solutions: Amazon Locker, building concierge, PO Box
- Ring doorbell cameras common

### USPS vs Others
- USPS generally reliable
- UPS/FedEx sometimes leave packages (theft risk)
- Building with package room = huge plus
