# Downtown Miami & Brickell

## Brickell

### Overview
Miami's financial district and young professional hub. Forest of luxury high-rises with rooftop pools, gym amenities, and Whole Foods in the lobby. Think Manhattan meets Miami.

### Rent (2024-2025)
| Type | Range | Notes |
|------|-------|-------|
| Studio | $2,200-2,800 | Rare, mostly in older buildings |
| 1BR | $2,800-4,000 | Standard for new towers |
| 2BR | $3,800-6,000 | Luxury buildings |
| Penthouse | $10,000+ | Brickell Key, Icon |

**Buildings worth considering:**
- SLS Brickell — Trendy, rooftop scene
- Brickell House — Good value, central
- Icon Brickell — Iconic, Mandarin Oriental amenities
- Rise/Reach at Brickell City Centre — Newest, connected to mall

### Vibe
- Weekdays: Finance bros, remote workers at coffee shops
- Weekends: Brunch culture, pool parties
- Age demographic: 25-40
- International: Heavy Latin American (especially Venezuelan, Colombian, Argentine)

### Pros
✅ **Metromover access** — Free transit to downtown, museums
✅ **Walkable** — Brickell City Centre, Mary Brickell Village, restaurants
✅ **Safe** — One of Miami's safest areas
✅ **High-rise amenities** — Pools, gyms, coworking spaces
✅ **Dining scene** — Komodo, Papi Steak, Novikov, La Mar

### Cons
❌ **No beach** — 15-20 min Uber to South Beach
❌ **Expensive** — Premium pricing for everything
❌ **Corporate feel** — Can feel soulless compared to Wynwood
❌ **Traffic** — Brickell Ave gets congested
❌ **Dating scene** — Very finance-bro heavy

### Best For
- Finance professionals
- Young professionals wanting amenities
- Remote workers who need good WiFi + coffee shops
- People who prioritize safety and convenience over beach

---

## Downtown Miami (Non-Brickell)

### Overview
The actual downtown core around Flagler Street, Government Center, and the waterfront. Less residential than Brickell, more commercial. Changing rapidly.

### Rent (2024-2025)
| Type | Range | Notes |
|------|-------|-------|
| 1BR | $2,000-2,800 | Older buildings, less amenities |
| 2BR | $2,500-3,500 | Some new developments |

### Key Areas
- **Downtown Core** — Government buildings, Flagler St, not residential
- **Arts & Entertainment District** — PAMM, Frost Science, Bayside
- **Overtown (adjacent)** — Historic Black neighborhood, gentrifying, caution advised

### Pros
✅ Cheaper than Brickell
✅ Near cultural institutions (PAMM, Frost Science)
✅ Metromover access
✅ Brightline station (train to Fort Lauderdale, West Palm)

### Cons
❌ Empty at night — most people commute out
❌ Homeless population around Government Center
❌ Few residential options
❌ Sketchy pockets nearby

### Best For
- Budget-conscious professionals
- People who work downtown
- Transit-oriented living

---

## Edgewater

### Overview
Bay-facing high-rises north of downtown, between Brickell and Design District. Rapidly developing, increasingly popular.

### Rent (2024-2025)
| Type | Range |
|------|-------|
| 1BR | $2,400-3,200 |
| 2BR | $3,200-4,500 |

### Vibe
- Quieter than Brickell
- Bay views, joggers on path
- Up-and-coming restaurant scene
- More residential feel

### Pros
✅ Better value than Brickell
✅ Margaret Pace Park — bay views, dog friendly
✅ Growing dining scene
✅ Close to Wynwood/Design District

### Cons
❌ Still developing — construction noise
❌ Fewer amenities than Brickell
❌ Need car for most things
❌ Some pockets still rough

### Best For
- People priced out of Brickell
- Dog owners (Margaret Pace Park)
- Those who want bay views without Brickell prices
