# Living Like a Local in Miami

## Cultural Norms

### Miami is Latin
- Spanish is everywhere (and often preferred)
- Cuban culture dominates but pan-Latin overall
- Greeting: Kiss on cheek is normal (one kiss, right cheek)
- Time is flexible ("Miami time" = 15-30 min late is normal)
- Family is priority (events center around family)

### The Vibe
- Casual dress is the norm (even at nice restaurants)
- Appearance matters (grooming, style appreciated)
- Flashy is acceptable (cars, clothes, jewelry)
- Work-life balance skews toward life
- Beach culture means fit/health-conscious

### What Surprises Newcomers
- How much Spanish you'll hear
- How late people eat dinner (8-10pm is normal)
- How important appearance is
- How everyone seems to know each other
- How bad drivers are

---

## Making Friends

### The Challenge
- Miami is transient (people come and go)
- Social scenes are segregated (finance, art, Latin, etc.)
- People are friendly but friendships take time

### Where to Meet People
| Activity | Where | Notes |
|----------|-------|-------|
| **Fitness** | F45, CrossFit, Barry's | Workout culture is huge |
| **Running clubs** | Brickell Run Club | Free, social |
| **Sports leagues** | Volo, ZogSports | Volleyball, kickball |
| **Co-working** | WeWork, Lab Miami | Entrepreneurs, remote workers |
| **Volunteering** | Feeding South Florida | Give back, meet people |
| **Church** | Various | Strong religious communities |
| **Alumni events** | College networks | If applicable |

### Tips
- Say yes to invitations (even awkward ones)
- Join something recurring (not one-off events)
- Beach/pool areas are social gathering spots
- Building amenities (pool, gym) create community
- Apps (Bumble BFF, Meetup) work for some people

---

## Local Events Calendar

### Monthly/Weekly
| Event | When | Where |
|-------|------|-------|
| **Wynwood Art Walk** | 2nd Saturday | Wynwood |
| **Lincoln Road farmers market** | Sunday | South Beach |
| **Coconut Grove farmers market** | Saturday | Grove |

### Annual Events
| Event | When | Notes |
|-------|------|-------|
| **Art Basel** | Early December | Art week, prices spike |
| **Ultra Music Festival** | March | EDM, downtown |
| **Miami Open** | March | Tennis, Hard Rock |
| **South Beach Wine & Food** | February | Celebrity chefs |
| **Calle Ocho Festival** | March | Cuban street party |
| **Carnaval on the Mile** | March | Coral Gables |
| **Miami Swim Week** | July | Fashion industry |
| **III Points** | October | Music festival, Wynwood |

### Sports
| Team | Sport | Venue | Season |
|------|-------|-------|--------|
| **Miami Heat** | NBA | FTX Arena | Oct-Apr |
| **Miami Dolphins** | NFL | Hard Rock Stadium | Sep-Jan |
| **Inter Miami** | MLS | DRV PNK Stadium | Feb-Oct |
| **Miami Marlins** | MLB | LoanDepot Park | Apr-Sep |
| **Panthers** | NHL (Sunrise) | FLA Live Arena | Oct-Apr |

---

## Local Lingo

### Spanish You'll Hear
| Word/Phrase | Meaning |
|-------------|---------|
| **Cafecito** | Cuban espresso |
| **Dale** | Let's go / OK / Do it |
| **Qué lo qué** | What's up (Dominican) |
| **Chévere** | Cool |
| **Papi/Mami** | Friendly term for anyone |
| **Asere** | Buddy (Cuban) |

### Miami-Specific Terms
| Term | Meaning |
|------|---------|
| **SoBe** | South Beach |
| **SoFi** | South of Fifth (South Beach) |
| **The Grove** | Coconut Grove |
| **The Gables** | Coral Gables |
| **The Roads** | Neighborhood near Brickell |
| **305** | Miami area code (identity) |
| **Publix sub** | Legendary grocery store sandwich |

---

## Quality of Life Hacks

### Beat the Heat
- Morning outdoor activities (before 11am)
- AC everywhere (know which stores/malls for breaks)
- Cold brew coffee culture
- Pool access is essential (gym, building, friend)

### Beat the Traffic
- Work flexible hours if possible
- Live near work (even if pricier, saves sanity)
- Use Waze religiously
- Know back roads (surface streets during rush hour)

### Beat the Cost
- Happy hours (real savings on drinks/food)
- Cuban food is cheap and filling
- Beach is free (best amenity in Miami)
- Free Metromover for downtown/Brickell
- Publix BOGO deals every week

### Stay Sane
- Find your "third place" (not home, not work)
- Regular beach time (it's therapeutic)
- Accept that Miami moves slow (appointments, service)
- Build community intentionally (it won't happen naturally)

---

## Local Truths

### Things Locals Know
1. **Versailles is for tourists** (but also fine, go once)
2. **Publix subs are actually good** (seriously)
3. **Beach on weekdays** (tourists have weekends)
4. **Never pay Ocean Drive prices** (for anything)
5. **Hurricanes are manageable** (with prep)
6. **Summer is when locals have the city** (embrace it)
7. **The best Cuban food is in Hialeah** (not Little Havana)
8. **Key Biscayne beaches beat South Beach** (for swimming)
9. **Brickell and Miami Beach are different worlds** (pick one)
10. **The 305 is a vibe, not just an area code** (embrace it)

### Signs You've Become a Local
- You complain about 65°F being "cold"
- You have a go-to ventanita for cafecito
- You know which Publix is "your Publix"
- You instinctively avoid Ocean Drive
- You've survived a hurricane (or three)
- You have a strong opinion on Cuban sandwiches
- You've been to Wynwood exactly once (for visitors)
