# Miami Food & Dining Overview

## What Makes Miami Food Special

Miami's food identity comes from:
1. **Cuban influence** — The foundation, everywhere
2. **Pan-Latin fusion** — Venezuelan, Colombian, Peruvian, Argentine, Brazilian
3. **Seafood** — Stone crab, Florida lobster, fresh catches
4. **Jewish deli tradition** — Especially in the Beach
5. **Haitian cuisine** — Little Haiti influence
6. **New wave fusion** — Celebrity chefs, upscale Latin

---

## Must-Try Miami Foods

| Food | What It Is | Where to Get It |
|------|------------|-----------------|
| **Cuban sandwich** | Ham, roast pork, swiss, pickles, mustard, pressed | Sanguich, Enriqueta's |
| **Cafecito** | Cuban espresso, strong and sweet | Any ventanita |
| **Croquetas** | Ham croquettes (or other fillings) | Islas Canarias, Sergio's |
| **Stone crab** | Seasonal (Oct-May), served cold with mustard | Joe's Stone Crab |
| **Frita** | Cuban burger with shoestring fries on top | El Rey de las Fritas |
| **Pastelito** | Flaky pastry, guava or meat filled | Any Cuban bakery |
| **Arepas** | Venezuelan corn cakes, stuffed | Doggi's Arepa Bar |
| **Ceviche** | Peruvian-style raw fish | CVI.CHE 105, La Mar |
| **Conch fritters** | Keys-style appetizer | Any seafood place |
| **Key lime pie** | Official Florida pie | Joe's, any diner |

---

## Price Guide

| Category | Per Person | Example Restaurants |
|----------|------------|---------------------|
| **Cheap** | $10-20 | Cuban spots, food trucks, Publix subs |
| **Casual** | $20-40 | Most Brickell restaurants, beach spots |
| **Nice dinner** | $50-100 | KYU, Mandolin, Jaguar |
| **Special occasion** | $100-200 | Carbone, Papi Steak, Cecconi's |
| **Ultra-luxury** | $200+ | Casa Tua, Major Food Group spots |

---

## Dining Scenes by Area

| Area | Vibe | Price Range | Best For |
|------|------|-------------|----------|
| **Brickell** | Trendy, see-and-be-seen | $$-$$$$ | Date nights, business dinners |
| **Wynwood** | Casual, creative | $-$$$ | Brunch, groups, casual |
| **South Beach** | Tourist + celebrity | $$-$$$$ | People watching, splurges |
| **Little Havana** | Authentic Cuban | $ | Cheap, real food |
| **Coral Gables** | Upscale traditional | $$-$$$ | Family dinners, events |
| **Design District** | Fashion crowd | $$$-$$$$ | Luxury dining |
| **Coconut Grove** | Casual waterfront | $$-$$$ | Brunch, relaxed dinners |

---

## Miami Dining Culture

### Reservations
- **Essential** for: Prime 112, Carbone, Komodo, any Major Food Group
- **Helpful** for: KYU, Swan, Cecconi's on weekends
- **Walk-in fine** for: Most Cuban places, casual spots
- **Use Resy** — Most Miami restaurants are on it

### Tipping
- Standard: 18-22%
- Many restaurants add auto-gratuity for parties 6+
- Check your bill — some add 18% automatically

### Dress Code
- Most places: Smart casual (no flip-flops, no tank tops)
- Upscale: Collared shirt, closed shoes, no shorts
- SoBe: More relaxed during day, nicer at night
- **Nobody dresses up like NYC** — Miami is casual

### Timing
- Dinner reservations: 7-9pm prime time
- Early bird: 5-7pm (often cheaper)
- Late night: 10pm+ for after-club crowd
- Brunch: 11am-2pm weekends, make reservations

### Payment
- Cash still works everywhere
- Some Cuban spots cash-only
- Credit cards fine at restaurants
- Venmo/Zelle common for smaller places

---

## Restaurant Red Flags

| Red Flag | Why Avoid |
|----------|-----------|
| Ocean Drive restaurants | Tourist traps, aggressive touts |
| Restaurants with picture menus outside | Usually mediocre |
| "Free parking" advertised | Sign of desperation |
| Host/hostess pushing table aggressively | They need customers |
| Too many cuisines (Mexican + Sushi + Italian) | Jack of all trades |
| "Best Cuban food" signs in tourist areas | Real Cuban spots don't advertise |

---

## Best Bets by Situation

| Situation | Go To |
|-----------|-------|
| Impressing someone | Carbone, The Surf Club |
| Budget date | Mandolin, Blue Collar |
| Family dinner | Versailles, Red Fish Grill |
| Group brunch | The Salty, Lolo's Surf Cantina |
| Late night eating | Coyo Taco, La Sandwicherie |
| Quick lunch | Cuban ventanita, Publix sub |
| Vegetarian-friendly | Plant Miami, Planta |
| Business dinner | Zuma, Novikov |
