# Cuban Food in Miami

## Essential Cuban Vocabulary

| Spanish | English | Notes |
|---------|---------|-------|
| **Cafecito** | Cuban espresso | Small, strong, pre-sweetened |
| **Colada** | Espresso to share | Comes with small cups |
| **Cortadito** | Espresso with milk | Miami's latte |
| **Café con leche** | Coffee with milk | Breakfast staple |
| **Ventanita** | Walk-up window | Where to get cafecito |
| **Croqueta** | Croquette | Usually ham, sometimes other |
| **Pastelito** | Flaky pastry | Guava, meat, or cheese filled |
| **Media noche** | Midnight sandwich | Sweeter bread than Cuban |
| **Frita** | Cuban burger | With shoestring fries on top |
| **Ropa vieja** | Shredded beef | "Old clothes" literally |
| **Lechón** | Roast pork | Usually slow-roasted |
| **Mojo** | Garlic sauce | On everything |
| **Yuca** | Cassava | Fried or boiled, with mojo |
| **Maduros** | Sweet plantains | Ripe, fried sweet |
| **Tostones** | Green plantains | Fried, smashed, fried again |

---

## The Cuban Sandwich

### Anatomy
- **Bread:** Cuban bread (soft inside, crispy outside)
- **Ham:** Sliced thin
- **Roast pork:** Mojo-marinated, sliced
- **Swiss cheese:** Melted
- **Pickles:** Dill pickles
- **Mustard:** Yellow mustard
- **Pressed:** In a plancha (sandwich press)

### Best Cuban Sandwiches

| Restaurant | Area | Price | Notes |
|------------|------|-------|-------|
| **Sanguich de Miami** | Little Havana | $14 | Elevated version, excellent pork |
| **Enriqueta's** | Upper East Side | $10 | Classic, cash only |
| **La Carreta** | Multiple | $11 | Reliable chain, authentic |
| **Versailles** | Little Havana | $12 | Iconic, tourist-friendly |
| **Sergio's** | Multiple | $10 | Local chain, solid |

### Cuban Sandwich Rules
- ❌ Never salami (that's Tampa-style)
- ❌ Never lettuce or tomato
- ❌ Never mayo
- ✅ Must be pressed hot
- ✅ Must have yellow mustard

---

## Best Cuban Restaurants

### Old School Classics
| Restaurant | Area | $$ | Must-Order |
|------------|------|-----|------------|
| **Versailles** | Little Havana | $ | Ropa vieja, vaca frita, atmosphere |
| **La Carreta** | Multiple | $ | Cuban sandwich, croquetas |
| **Islas Canarias** | Little Havana | $ | Croquetas (best in Miami) |
| **El Exquisito** | Little Havana | $ | Counter service, authentic |
| **La Rosa** | Hialeah | $ | Locals only, excellent lechón |

### Modern Cuban
| Restaurant | Area | $$$ | Must-Order |
|------------|------|-----|------------|
| **Café La Trova** | Little Havana | $$ | Cocktails, live music, elevated Cuban |
| **Havana Harry's** | Coral Gables | $$ | Upscale Cuban, great vaca frita |
| **Sanguich de Miami** | Little Havana | $$ | Gourmet sandwiches |

### Breakfast Spots
| Restaurant | Area | $ | Must-Order |
|------------|------|-----|------------|
| **Enriqueta's** | Upper East Side | $ | Cuban toast, café con leche |
| **El Pub** | Little Havana | $ | Full breakfast, cheap |
| **Any ventanita** | Everywhere | $ | Pastelito + cafecito |

---

## Ventanita (Walk-Up Window) Culture

### How It Works
1. Walk up to window (usually side of restaurant)
2. Order cafecito, colada, or cortadito
3. Pay cash (usually $1-3)
4. Drink standing at counter
5. Move on with your day

### Best Ventanitas
- **Versailles** (Little Havana) — Iconic, tourist but real
- **El Exquisito** (Little Havana) — Locals
- **Any bodega** — Look for coffee window

### Ordering Tips
- "Un cafecito" = one espresso ($1-2)
- "Una colada" = espresso to share, comes with cups ($3-4)
- "Un cortadito" = espresso with milk ($2-3)
- Shots are pre-sweetened unless you ask

---

## Little Havana Guide

### Calle Ocho (8th Street) Must-Dos
| Spot | What | Notes |
|------|------|-------|
| **Máximo Gómez Park** | Domino park | Watch locals play |
| **Versailles** | Restaurant | Cuban institution |
| **Ball & Chain** | Bar/club | Live music, historic |
| **Azucar Ice Cream** | Ice cream | Cuban flavors |
| **Cigar shops** | Cigars | Hand-rolled, multiple shops |
| **Fruit stands** | Fresh fruit | Try mamey, guanabana |

### Tourist Traps to Avoid
- Restaurants with people outside holding menus
- Overpriced fruit cups ($10+ is too much)
- "Free" salsa dancing lessons (sell you something)

### Real Local Spots (Off Calle Ocho)
- **Islas Canarias** (SW 8th, further west) — Best croquetas
- **El Rey de las Fritas** (SW 8th) — Best fritas
- **La Rosa** (Hialeah, not Little Havana) — Real local Cuban
