# Miami Climate & Weather

## Overview

Miami has a **tropical monsoon climate** — hot, humid summers with afternoon storms and warm, dry winters.

| Season | Months | Temperature | Rain | Humidity |
|--------|--------|-------------|------|----------|
| **Dry season** | Nov-Apr | 65-82°F | Rare | 50-65% |
| **Wet season** | May-Oct | 75-92°F | Daily storms | 70-85% |

---

## Monthly Breakdown

| Month | Avg High | Avg Low | Rain Days | Notes |
|-------|----------|---------|-----------|-------|
| Jan | 76°F | 60°F | 5 | Peak tourist season |
| Feb | 78°F | 61°F | 5 | Perfect weather |
| Mar | 80°F | 64°F | 5 | Spring break crowds |
| Apr | 83°F | 68°F | 6 | Warming up |
| May | 86°F | 72°F | 10 | Wet season starts |
| Jun | 88°F | 76°F | 14 | Hurricane season begins |
| Jul | 90°F | 77°F | 14 | Hot and humid |
| Aug | 90°F | 77°F | 15 | Peak hurricane risk |
| Sep | 88°F | 76°F | 15 | Peak hurricane risk |
| Oct | 85°F | 73°F | 12 | Hurricane season winding down |
| Nov | 80°F | 67°F | 7 | Dry season begins |
| Dec | 77°F | 62°F | 5 | Perfect weather |

---

## Summer Reality (June-September)

### What to Expect
- **Hot:** 88-92°F daily highs
- **Humid:** 80%+ humidity feels brutal
- **Afternoon storms:** Almost daily, 3-6pm typical
- **Heat index:** Often 100-110°F (feels like)

### Coping Strategies
1. **Plan outdoor activities for morning** (before noon)
2. **Expect afternoon storms** (30-60 min, then clears)
3. **Stay hydrated** (more water than you think)
4. **AC is essential** (not optional)
5. **Dress light** (linen, moisture-wicking fabrics)
6. **Car will be oven** (use sunshade, crack windows)

### Summer Upside
- Fewer tourists
- Cheaper hotels
- Locals-only vibe
- Storms are dramatic (can be beautiful)

---

## Winter Reality (November-April)

### What to Expect
- **Warm days:** 75-82°F
- **Cool nights:** 55-65°F
- **Low humidity:** 50-65% (comfortable)
- **Rain:** Occasional, not daily
- **Cold fronts:** Occasionally drop temps to 50s

### "Cold" Weather
- Miamians consider 60°F "freezing"
- You might need a light jacket at night
- Some days are legitimately perfect
- Pool might feel cold in January

### Winter Packing
- Light layers (cardigan, light jacket)
- No heavy coat needed (ever)
- Sunscreen still necessary
- Sunglasses always

---

## Hurricane Season Deep Dive

### Timeline
- **June 1:** Official start
- **June-July:** Usually quiet
- **August-October:** Peak activity
- **November 30:** Official end

### Historical Context
| Storm | Year | Category | Damage |
|-------|------|----------|--------|
| Andrew | 1992 | 5 | Devastated Homestead |
| Wilma | 2005 | 3 | Significant flooding |
| Irma | 2017 | 4 | Major evacuations |
| Ian | 2022 | 4 | Hit SW Florida, Miami spared |

### Probability in Any Given Year
- Direct hit on Miami: ~5-10% chance
- Tropical storm impact: ~20-30% chance
- Feeling effects: ~40-50% chance

**Don't be paranoid, but be prepared.**

---

## Microclimate Differences

### Beach vs. Mainland
| Factor | Beach | Mainland |
|--------|-------|----------|
| Temperature | 2-5°F cooler | Hotter |
| Sea breeze | Strong afternoon | Weaker |
| Humidity | Consistent | More variation |
| Flooding risk | Storm surge | Street flooding |

### North vs. South Miami-Dade
- Similar temperatures
- Southern areas (Homestead) slightly hotter
- Northern areas (Aventura) slightly windier

---

## Weather Apps & Resources

### Best Apps
| App | Use For |
|-----|---------|
| **Dark Sky** | Minute-by-minute rain prediction |
| **NOAA Weather** | Hurricane tracking |
| **Waze** | Flood reports on roads |
| **Weather Underground** | Hyperlocal forecasts |

### Hurricane Tracking
- **National Hurricane Center:** nhc.noaa.gov
- **WSVN (local):** First Warning weather team
- **WPLG Local 10:** Good coverage
- **Cone of uncertainty:** Shows possible paths

---

## Seasonal Planning

### Best Time to Visit
1. **November-December:** Perfect weather, before holiday prices
2. **January-March:** Great weather, peak prices, crowds
3. **April-May:** Warming up, fewer tourists, deals

### When to Avoid
1. **August-September:** Hurricane peak, oppressive heat
2. **March (Spring Break):** Crowds, chaos in SoBe
3. **Art Basel week (December):** Unless you're there for that (prices 3x)

### When Locals Love Miami
- Early November (perfect weather, empty)
- Late January (winter visitors gone)
- Late April (before summer heat hits)
