---
name: Miami
slug: miami
version: 1.0.0
description: Navigate Miami as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, beaches, costs, safety, and local insights.
metadata: {"clawdbot":{"emoji":"🌴","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Miami for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions & beaches | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Downtown & Brickell | `neighborhoods-downtown.md` |
| Miami Beach | `neighborhoods-beach.md` |
| Wynwood & Design District | `neighborhoods-wynwood.md` |
| Coral Gables & Coconut Grove | `neighborhoods-coral.md` |
| North (Aventura, Sunny Isles) | `neighborhoods-north.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Cuban cuisine & Little Havana | `food-cuban.md` |
| Latin American flavors | `food-latin.md` |
| Seafood | `food-seafood.md` |
| Best dining areas | `food-areas.md` |
| Dietary & tips | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport | `transport.md` |
| Cost of living | `cost.md` |
| Safety | `safety.md` |
| Weather & hurricanes | `climate.md` |
| Local services | `local.md` |
| **Career** | |
| Tech industry | `tech.md` |
| Students | `student.md` |
| Startups | `startup.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Safety Context
Miami is generally safe in tourist/residential areas. Main concerns:
- Car break-ins (don't leave valuables visible)
- Petty theft in tourist areas
- Avoid certain neighborhoods at night
See `safety.md` for area-specific guidance.

### 3. Weather Reality
- Hot and humid year-round (avg 77°F/25°C)
- Hurricane season: June 1 - November 30
- Rainy season: May-October (afternoon thunderstorms)
- Best months: November-April (dry, pleasant)
See `climate.md` for hurricane prep.

### 4. Current Data
| Item | Range |
|------|-------|
| 1BR rent | $2,200-3,500 (Brickell/Beach) |
| Senior SWE salary | $120K-180K (no state tax) |
| Student budget | $1,800-2,500/month |
| Car insurance | $200-400/month (FL crisis) |

### 5. Tourist Traps
- Skip: Ocean Drive (overpriced), Bayside Marketplace, chain restaurants
- Do: Little Havana, Wynwood Walls, Key Biscayne, Coral Gables
- Free: South Beach (early morning), Wynwood street art, Brickell City Centre

### 6. Car Is Essential
- Miami is NOT walkable (unlike NYC/London)
- Public transit limited (Metrorail, Metromover downtown only)
- Brightline train to Fort Lauderdale/West Palm useful
- Uber/Lyft expensive for daily use
- Budget for car + parking + insurance

### 7. Neighborhood Matching
| Profile | Best Areas |
|---------|------------|
| Young professionals | Brickell, Edgewater, Midtown |
| Families | Coral Gables, Coconut Grove, Pinecrest |
| Beach lifestyle | Miami Beach, Surfside, Key Biscayne |
| Budget-conscious | Doral, Kendall, Hialeah |
| Tech workers | Wynwood, Brickell, Design District |

## Miami-Specific Traps

- **"Beach party 24/7"** — South Beach is tourists. Locals rarely go.
- **"No need for a car"** — FALSE. Miami is car-dependent.
- **"Cheap alternative to NYC"** — Rent is now comparable, with lower salaries.
- **Ocean Drive** — Tourist trap. Walk to Lincoln Road or Española Way.
- **Hurricane ignorance** — Know your evacuation zone. Get supplies early.
- **Car insurance shock** — Florida has highest rates in US. Budget $3-4K/year.
- **Condo fees** — Post-Surfside reforms mean high assessments. Ask about reserves.
