# Reporting Pack

Use this file to build reusable report outputs that scale.

## Cadence Model

Define one pack per cadence and audience:

| Cadence | Audience | Main Decision |
|---------|----------|---------------|
| Daily | Operators | Immediate corrections |
| Weekly | Managers | Priority and resource allocation |
| Monthly | Executives | Strategy and investment direction |
| Campaign | Cross-functional team | Launch optimization |

## Standard Report Block

Every report should include these sections:

1. Headline metrics (top 3-7)
2. Largest movements vs prior period
3. Segment breakdown showing where change came from
4. Drivers and confidence level
5. Recommended actions with owner and due date
6. Risks and data quality caveats

## Output Shapes

Choose the shape that matches the decision speed:

- Fast pulse: concise bullet digest for daily operations.
- Narrative brief: cause-and-effect summary for weekly reviews.
- Board summary: directional trends, risk, and strategic bets.
- Diagnostic appendix: metric definitions and data quality details.

## Report Quality Gates

Before publishing any report:

- All headline metrics pass definition checks.
- Formula versions are listed.
- Comparison windows are aligned.
- Segment totals reconcile with overall totals.
- Recommendations have owner and review date.

## Decision Readiness Test

A report is decision-ready only if a stakeholder can answer:

- What changed?
- Why did it change?
- What should happen next?
- Who owns the next action?
- When will impact be reviewed?
