---
name: Metaverse
description: Navigate virtual worlds, create avatars, manage digital assets, and understand Web3 social platforms.
metadata:
  category: technology
  skills: ["metaverse", "vr", "web3", "virtual-worlds", "nft"]
---

## Before Recommending Platforms

- Ask what they want to do: socialize, create, game, invest, attend events
- Ask their hardware: VR headset, desktop, mobile changes options significantly
- Ask technical comfort: some platforms require crypto wallets, others don't
- One platform recommendation beats list of 20 confusing options
- Platform popularity shifts fast: verify current state before recommending

## Platform Categories

| Type | Examples | Best For |
|------|----------|----------|
| Social VR | VRChat, Rec Room | Hanging out, events, no crypto needed |
| Virtual worlds | Decentraland, The Sandbox | Land ownership, creating, crypto-native |
| Gaming metaverse | Roblox, Fortnite | Games with social layer, younger audiences |
| Work/meetings | Horizon Workrooms, Spatial | Professional collaboration in VR |

Match platform to goal, not hype.

## Crypto Wallet Guidance

- Not all metaverse requires crypto: VRChat, Rec Room, Roblox work without
- When needed: explain wallet setup is one-time, can be intimidating but not complex
- Recommend established wallets: MetaMask for browser, Coinbase for beginners
- Warn about seed phrase importance: lose it, lose everything, no recovery
- Gas fees vary wildly: some actions cost $1, some $50+, check before confirming

## Avatar and Identity

- Avatar investment varies: free options exist on every platform
- Interoperability is mostly marketing: avatars rarely transfer between platforms
- Identity can be pseudonymous: don't pressure real name/photo
- Customization depth varies: some platforms have detailed creators, others don't
- NFT avatars: ownership verified, but only valuable if platform supports them

## Digital Asset Reality

- Most virtual land/items have no resale market: illiquid assets
- "Investment" framing is risky: prices crashed 90%+ from peaks
- Utility matters more than speculation: does it do something useful?
- Gas fees can exceed item price: check transaction costs
- Scams are common: verify official links, never share seed phrases

## Event Attendance

- Check time zones: virtual events are still time-bound
- Technical setup before event: test audio, controls, performance
- Some events require tickets/passes: verify requirements in advance
- Recording may not be allowed: check event policies
- Networking works differently: intentional interaction needed

## Creating in Metaverse

- Each platform has different creation tools: learn one deeply first
- 3D modeling skills transfer: Blender works for multiple platforms
- Start with platform's native tools: lower barrier, platform-specific features
- Monetization rules vary: some take 0%, some take 30%+
- Building on rented land: understand platform terms of service

## Hardware Considerations

- VR headset not required for most: desktop/mobile access usually available
- Quest 2/3 is current mainstream VR entry point: standalone, reasonable price
- PC VR needs powerful computer: check requirements before recommending
- Motion sickness is real: suggest starting with stationary experiences
- VR session length: 30-60 min at first, eyes and body need breaks

## Safety Guidance

- Personal boundaries matter: harassment exists in virtual spaces too
- Privacy settings exist: help configure before first session
- Block and report features: know where they are before needing them
- Voice chat optional: can mute, use text, or disable
- Kids need supervision: age-appropriate platforms exist, enforce them

## Common Misconceptions

- "The metaverse" as single place: it's many disconnected platforms
- Interoperability "coming soon": has been promised for years, limited progress
- Necessary for future: optional entertainment, not essential infrastructure
- All crypto-based: many popular platforms have no blockchain at all
- VR required: most accessed via screen, not headset
