---
name: metaso-search
description: 提供对 Metaso 搜索 API 的直接访问，支持网页搜索、内容读取和智能问答功能
metadata:
  {
    "openclaw": { "requires": { "env": ["METASO_API_KEY"] } },
  }
---

# Metaso Search 技能

## 描述

提供对 Metaso 搜索 API 的直接访问，支持网页搜索、内容读取和智能问答功能。

## 功能

### 1. 网页搜索 (`metaso_web_search`)
根据关键词搜索网页、文档、论文、图片、视频、播客等内容。

**参数：**
- `q`: 搜索查询关键词（必填）
- `size`: 返回结果数量（必填，1-100）
- `scope`: 搜索范围（必填）
- `includeSummary`: 是否包含精简的原文匹配信息（必填）
- `includeRawContent`: 是否通过网页的摘要信息进行召回增强（必填）
- `conciseSnippet`: 是否抓取所有来源网页原文（必填）

### 2. 网页内容读取 (`metaso_web_reader`)
读取指定 URL 的网页内容。

**参数：**
- `url`: 要读取的 URL 地址（必填）
- `format`: 输出格式（必填，json 或 markdown）

### 3. 智能问答 (`metaso_chat`)
基于 RAG 的智能问答服务。

**参数：**
- `messages`: 用户消息数组（必填）
- `model`: 使用的模型（必填）
- `scope`: 搜索范围（必填）
- `format`: 输出格式（必填）
- `stream`: 是否开启流式输出（必填）
- `conciseSnippet`: 是否返回精简的原文匹配信息（必填）

## 配置

### 环境变量配置

**必要配置：**
```bash
# Linux/macOS
export METASO_API_KEY="您的API密钥"

# Windows (PowerShell)
$env:METASO_API_KEY="您的API密钥"
```

**OpenClaw 配置：**
在 OpenClaw 配置文件 `openclaw.json` 中添加：
```json
{
  "env": {
    "METASO_API_KEY": "您的API密钥"
  }
}
```

## 使用方法

```javascript
import { metasoSearch, metasoReadPage, metasoChat } from './skills/metaso-search/metaso-api.js';

// 搜索
const searchResult = await metasoSearch('人工智能', 2, 'document', true, false, true);

// 读取网页内容
const contentResult = await metasoReadPage('https://example.com', 'json');

// 智能问答
const chatResult = await metasoChat(
  [{ role: 'user', content: '什么是机器学习？' }], 
  'fast', 
  'webpage', 
  'simple', 
  false, 
  true
);
```

## 文件说明

### `metaso-api.js` - API 核心模块
- 提供所有 API 方法的实现
- 包含自动配置加载
- 错误处理和重试机制
- 使用 Metaso HTTP API 端点

### `quick-test.js` - 快速测试脚本
- 用于快速验证 API 基本功能的简化测试
- 包含搜索和聊天功能的基本测试

### `simple-test.js` - 简单功能测试
- 测试所有 API 功能的详细测试脚本
- 包含搜索、内容读取和聊天功能的测试

## 运行测试

```bash
cd skills/metaso-search
node quick-test.js
```

## 故障排除

### API 密钥未配置
```
Error: METASO_API_KEY 环境变量未设置，请在使用前配置
```

**解决方法**：设置 METASO_API_KEY 环境变量

### 认证失败
```
Error: API密钥无效
```

**解决方法**：检查 API 密钥是否正确

## 版本信息

- 当前版本: 2.1.0
- 移除了硬编码的默认 API 密钥
- 优化了配置管理
- 简化了文档结构
