---
name: Price
description: 全球铁合金网价格查询与导出技能。自动登录www.qqthj.com网站，查询指定金属(如锰铁、钒铁等)的当日价格数据，抓取价格表格并导出为Excel文件。
read_when:
  - 用户需要查询全球铁合金网的金属价格
  - 用户需要导出价格数据到Excel
  - 用户需要进行金属市场行情分析
  - 用户需要定期获取金属价格数据
metadata:
  openclaw:
    emoji: "📊"
    requires:
      bins: []
allowed-tools: Bash(price:*)
---

# Price - 全球铁合金网价格查询

## 概述

此技能用于自动化查询全球铁合金网(www.qqthj.com)的金属价格数据。

**目标网站**: https://www.qqthj.com
**执行时间**: 约18-28秒

## 执行流程

```
开始
↓
1. 登录网站
↓
2. 导航到目标金属分类
↓
3. 查询当日价格数据
↓
4. 抓取价格表格
↓
5. 导出为Excel
↓
结束
```

## 使用说明

### 登录信息
- **网站**: https://www.qqthj.com
- **用户名**: 13327325057
- **密码**: 1234567890

### 操作步骤

#### 阶段一: 网站登录

| 步骤 | 操作 | 说明 | 等待时间 |
|------|------|------|----------|
| 1 | 打开网站 | URL: https://www.qqthj.com | 2-3秒 |
| 2 | 点击登录 | 页面左上角"登录"按钮 | 1秒 |
| 3 | 输入用户名 | 13327325057 | - |
| 4 | 输入密码 | 1234567890 | - |
| 5 | 点击登录 | 提交按钮 | 1-2秒 |

**元素选择器**:
- 用户名: `input[type="text"]` 或 `input[name="username"]`
- 密码: `input[type="password"]` 或 `input[name="password"]`
- 登录按钮: `button[type="submit"]` 或包含"登录"文本的按钮

#### 阶段二: 数据查询导航

| 步骤 | 操作 | 说明 | 等待时间 |
|------|------|------|----------|
| 1 | 识别金属菜单 | 首页导航栏金属分类 | - |
| 2 | 点击金属菜单 | 如"锰"、"钒"等 | 即时 |
| 3 | 展开下拉菜单 | 自动展开子菜单 | 即时 |
| 4 | 点击金属子类 | 如"锰铁"、"钒铁"等 | 2秒 |
| 5 | 定位价格区域 | 找到"国内价格"模块 | - |
| 6 | 点击当日价格链接 | 包含日期+金属名称+价格 | 2秒 |

**元素选择器**:
- 金属菜单: 导航栏中包含金属名称的菜单项
- 价格链接: `a`标签，文本包含日期+金属名称+"价格"

#### 阶段三: 数据抓取与导出

| 步骤 | 操作 | 说明 |
|------|------|------|
| 1 | 页面加载 | 等待价格详情页加载 | 1-2秒 |
| 2 | 滚动页面 | 滚动到表格可见区域 | - |
| 3 | 定位表格 | 找到价格表格 | - |
| 4 | 抓取数据 | 提取所有行列数据 | - |
| 5 | 导出Excel | 保存为.xlsx文件 | - |

**元素选择器**:
- 价格表格: `table`标签，位于价格详情页

### 参数配置

| 参数名称 | 默认值 | 说明 | 示例 |
|----------|--------|------|------|
| 用户名 | 13327325057 | 登录账号 | 手机号 |
| 密码 | 1234567890 | 登录密码 | - |
| 金属类型 | 锰 | 主菜单选择 | 钒、钛、钨、钼等 |
| 金属子类 | 锰铁 | 子菜单选择 | 高碳锰铁、中碳锰铁等 |
| 查询日期 | 当日 | 价格日期 | 1月30日、2月1日等 |
| 导出路径 | 固定路径 | **必须**保存到此路径 | C:\Users\wangxiang\Desktop\阶跃产出结果\Excel文件 |

### 导出文件命名

建议格式: `YYYYMMDD_金属名称_价格.xlsx`

示例:
- `20260130_高碳锰铁价格.xlsx`
- `20260130_钒铁价格.xlsx`

## 使用示例

### 示例1: 查询当日锰铁价格

```
执行SKILL: Price
参数:
  - 金属类型: 锰
  - 金属子类: 锰铁
  - 查询日期: 今天
```

### 示例2: 查询钒铁价格

```
执行SKILL: Price
参数:
  - 金属类型: 钒
  - 金属子类: 钒铁
  - 查询日期: 今天
```

## 异常处理

| 问题 | 可能原因 | 解决方案 |
|------|----------|----------|
| 登录失败 | 用户名或密码错误 | 检查账号密码 |
| 找不到登录按钮 | 页面加载未完成 | 增加等待时间 |
| 下拉菜单未展开 | 点击未触发 | 使用JavaScript触发点击 |
| 找不到价格链接 | 日期格式不匹配 | 检查日期格式 |
| 表格加载失败 | 网络延迟 | 刷新页面重试 |
| 导出失败 | 路径错误或权限不足 | 检查保存路径 |

## 注意事项

1. **⚠️ 重要**: Excel文件**必须**保存到 `C:\Users\wangxiang\Desktop\阶跃产出结果\Excel文件` 文件夹

2. **登录凭证安全**: 妥善保管用户名和密码

3. **日期格式**: 价格链接的日期格式为"X月XX日"，需动态生成

4. **网络稳定性**: 确保网络连接稳定

5. **数据时效性**: 价格数据通常在工作日更新

6. **表格结构**: 不同金属的表格结构可能略有差异

7. **文件覆盖**: 导出前检查是否存在同名文件

## 扩展功能

1. **批量查询**: 支持一次查询多个金属类型
2. **历史数据**: 支持查询指定日期范围的历史价格
3. **数据对比**: 自动对比不同日期的价格变化
4. **定时任务**: 设置定时自动执行
5. **数据分析**: 在Excel中自动生成价格趋势图表
6. **邮件通知**: 数据获取完成后发送邮件通知