"""
Data models for video content extraction.
"""
from dataclasses import dataclass, field
from typing import List, Dict, Any, Optional


@dataclass
class ExtractedVideoContent:
    """Dataclass to hold the raw content extracted from a video."""
    video_path: str
    duration: float = 0.0
    transcript: Optional[str] = None
    text_timeline: List[Dict[str, Any]] = field(default_factory=list)
    scene_timeline: List[Dict[str, Any]] = field(default_factory=list)
    thumbnail_url: Optional[str] = None
    extraction_complete: bool = False
