# Scene Reconciliation Prompts

## Combine Scene Descriptions

### Template: combine_scene_descriptions
```
You are analyzing a marketing video. You have two descriptions of the same video from different analysis methods:

**Frame-based analysis:** {{frame_description}}

**Native video analysis:** {{native_description}}

These describe the same video but from different perspectives. The frame-based analysis provides detailed visual snapshots, while the native analysis captures flow, transitions, and pacing.

Combine these two descriptions into a single, comprehensive description that:
- Includes all important visual details from both sources
- Captures transitions and flow
- Maintains temporal accuracy
- Stays concise (2-3 sentences maximum)

Combined description:
```

## Batch Combine Scene Descriptions

### Template: batch_combine_scene_descriptions
```
## Task
Combine frame-based visual descriptions with native video motion/flow analysis.

## Input Data

**FRAME SCENES (visual snapshots at key moments):**
{{frame_scenes}}

**NATIVE SCENES (motion & transitions):**
{{native_scenes}}

Note: Native scenes may use various formats (time ranges like "2-6s", single timestamps like "3.5s", or any temporal indication). Match frame timestamps to the most relevant native scene(s) regardless of format.

## Matching Logic

For each frame timestamp, apply this algorithm:

1. **Check containment:** Is the frame timestamp within ANY native scene's time range?
   - Example: Frame 3.00s is within native range "2-6s" (because 2 ≤ 3 ≤ 6)
   - Example: Frame 1.00s is NOT within "2-6s" (because 1 < 2)

2. **Combine or preserve:**
   - IF MATCH FOUND: Merge frame's visual details + matched native's motion/transitions
   - IF NO MATCH: Use frame description unchanged

3. **Output:** Always return description for every frame (never skip)

## Output Requirements

- **Count:** Return exactly {{frame_count}} descriptions (one per frame, 1:1 mapping)
- **Format:** `<timestamp>s: <description>` (one per line)
- **Order:** Match the frame timestamp order exactly
- **Content:** Each line must start with a number

## Format Examples

CORRECT FORMAT:
0.00s: Platinum card on dark surface
14.00s: Calendar interface with animated counters incrementing
18.00s: Search interface displaying offers

## Critical Reminders

1. **1:1 Mapping:** You must return exactly {{frame_count}} descriptions
2. **Never skip frames:** Even frames without native matches must be in output
3. **Time containment:** Check if frame timestamp is INSIDE native time range (start ≤ frame ≤ end)
4. **Preserve unchanged:** Frames without matches keep original frame description
5. **Format strict:** `<number>s: <text>` - nothing else

Begin combining the scenes now.
```

## Extract Text from Scenes

### Template: extract_text_from_scenes
```
Analyze these scene descriptions from a video and extract any text overlays, signs, or written text that appear:

{{scenes}}

List each text element with its approximate timestamp. Only include text that is clearly visible in the descriptions.

Format as:
timestamp: text content

If no text is mentioned, return "No text overlays detected"
```

## Reconcile Text Sources

### Template: reconcile_text_sources
```
You have two sources of text from the same video:

SOURCE 1 (OCR - direct text detection):
{{ocr_texts}}

SOURCE 2 (Gemini Vision - text from scene descriptions):
{{gemini_texts}}

Reconcile these into a single, accurate timeline of text overlays. Prefer OCR for accuracy, but use Gemini Vision to fill gaps or provide context.

Format each entry as:
timestamp: text content

Return a deduplicated, chronological list.
```
