# Scene Analysis Prompts

## Frame Analysis

### Template: frame_analysis
```
Analyze these sequential frames from a marketing ad. For each frame:
1. What's happening in this specific moment?
2. Note any text overlays
3. Focus on changes from previous frame
4. Maximum 2 sentences per frame
5. Ignore static elements unless newly relevant

REQUIRED FORMAT: For each frame, your response MUST follow this EXACT format:
Frame [timestamp]: [1-2 concise sentences about what's new]

For example:
Frame 2.50: A person demonstrates the product with an excited expression. Text overlay shows "AMAZING RESULTS".

DO NOT deviate from this format. Each frame description MUST start with "Frame" followed by the timestamp.
```

## Native Video Analysis

### Template: native_video_timeline
```
Analyze this marketing video and list each distinct scene with timestamp and description.

Focus on:
- Visual content and key moments
- Transitions and flow between scenes
- Camera movements and pacing
- Text overlays and graphics

Format each line as: timestamp: description

Example:
0.0: Woman speaks to camera with warning sign backdrop
3.5: Smooth transition to product demo, camera zooms to tablet
6.0: Close-up hands interacting with colorful game pieces
10.0: Text overlay "Download Now" appears with CTA button

Be specific about visuals, transitions, and timing.
```

## OCR Text Proofreading

### Template: proofread_ocr_text
```
Proofread these OCR-detected text strings from a video. Fix errors to improve readability.

**INPUT ({{count}} items):**
{{texts}}

**FIX:**
1. Spelling: 'nutriti0nal' → 'nutritional'
2. Spacing: 'working1on1' → 'working 1-on-1'
3. Character confusion: '0'↔'O', 'l'↔'I', '1'↔'l'
4. Combine obvious fragments: "Mille" + "nnial" → "Millennial"
5. Split merged text: "GetStartedToday" → "Get Started Today"

**RULES:**
- Return ONLY corrected text, one per line
- Preserve meaning
- Combining/splitting is allowed if it improves clarity
- No explanations or meta-text
- Expected output: ~{{count}} lines (exact count may vary)

**OUTPUT FORMAT:**
```
corrected text 1
corrected text 2
corrected text 3
...
```
```

## Structured Summary Generation

### Template: structured_summary
```
Analyze this ad content and provide a structured summary:

Visual Scenes:
{{scenes}}

Text Overlays:
{{text_timeline}}

Spoken Content:
{{transcript}}

Format your response as PLAIN TEXT ONLY with these exact section headers (NO markdown, NO asterisks, NO formatting):

Product/App: [Product name ONLY, MAX 10 words]

Key Features: [List 3-4 MOST important features ONLY]
Feature: Brief description (MAX 15 words)
Feature: Brief description (MAX 15 words)
Feature: Brief description (MAX 15 words)

Target Audience: [Primary segment ONLY, MAX 15 words]

CRITICAL WORD LIMITS - STRICTLY ENFORCE:
- Product/App: 10 words maximum
- Each feature line: 15 words maximum (total 3-4 features only)
- Target Audience: 15 words maximum
- NO Call to Action section

CRITICAL FORMATTING RULES:
- DO NOT use markdown formatting of any kind
- DO NOT use asterisks (*) or bold (**text**)
- DO NOT use bullet points or dashes (-, •)
- DO NOT add extra asterisks around section names
- Just write plain text with simple line breaks
- Format features like "Feature: Description" (colon separated)
- Be extremely concise - every word counts

Be specific about actual content shown.
```
