---
name: messari-crypto
description: >
  Crypto market intelligence powered by Messari's REST API. Provides real-time access to
  Messari AI (chat completions over 30TB+ crypto data), Signal (sentiment, mindshare, trending
  narratives), Metrics (prices, volumes, fundamentals for 34,000+ assets across 210+ exchanges),
  News, Research, Stablecoins, Exchanges, Networks, Protocols, Token Unlocks, Fundraising, Intel,
  Topics, and X-Users data.
  Use when the user asks about crypto markets, token analysis, sentiment, protocol metrics, asset
  research, trending narratives, stablecoin flows, token unlock schedules, fundraising rounds,
  governance events, or any blockchain/crypto data question.
  Requires a Messari API key and Messari AI credits.
metadata:
  openclaw:
    env:
      - name: MESSARI_API_KEY
        description: Messari API key from messari.io/api
        required: true
---

# Messari Crypto Intel

Real-time crypto market intelligence via Messari's REST API — AI-powered analysis,
on-chain metrics, sentiment, news, and institutional-grade research without building data pipelines.

## Prerequisites

- **Messari API Key** — get one at [messari.io/api](https://messari.io/api)
- **Messari AI Credits** — required for AI completion endpoints

## REST API Overview

**Base URL:** `https://api.messari.io`

**Authentication:** Include your API key in every request:

```
x-messari-api-key: <YOUR_API_KEY>
```

All endpoints accept and return JSON. Use `Content-Type: application/json` for POST requests.

## Service Routing Table

| Service | Base Path | Use When |
|---|---|---|
| **AI** | `/ai/` | General crypto questions, synthesis across data sources |
| **Signal** | `/signal/v1/` | Sentiment, mindshare, trending narratives |
| **Metrics** | `/metrics/v2/` | Price, volume, market cap, fundamentals |
| **News** | `/news/v1/` | Real-time crypto news, breaking events |
| **Research** | `/research/v1/` | Institutional reports, protocol deep dives |
| **Stablecoins** | `/stablecoins/v2/` | Stablecoin supply, per-chain breakdowns |
| **Exchanges** | `/exchanges/v2/` | Exchange volume, metrics, timeseries |
| **Networks** | `/networks/v2/` | L1/L2 network metrics, timeseries |
| **Protocols** | `/protocols/v2/` | DeFi protocol metrics (DEX, lending, staking) |
| **Token Unlocks** | `/token-unlocks/v1/` | Vesting schedules, unlock events |
| **Fundraising** | `/fundraising/v1/` | Funding rounds, investors, M&A |
| **Intel** | `/intel/v1/` | Governance events, protocol updates |
| **Topics** | `/topics/v1/` | Trending topic classes, daily timeseries |
| **X-Users** | `/signal/v1/x-users/` | Crypto X/Twitter user metrics |

For detailed endpoint documentation, see [references/api_services.md](references/api_services.md).

## Example Requests

### AI Chat Completion

```bash
curl -X POST "https://api.messari.io/ai/v1/chat/completions" \
  -H "x-messari-api-key: $MESSARI_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "messages": [
      {"role": "user", "content": "What is the bull case for ETH right now?"}
    ]
  }'
```

### Asset Metrics Lookup

```bash
curl "https://api.messari.io/metrics/v2/assets?assetSlugs=bitcoin,ethereum" \
  -H "x-messari-api-key: $MESSARI_API_KEY"
```

### Signal Mindshare Gainers

```bash
curl "https://api.messari.io/signal/v1/assets/gainers-losers?type=mindshare&limit=10" \
  -H "x-messari-api-key: $MESSARI_API_KEY"
```

### News Feed

```bash
curl "https://api.messari.io/news/v1/news/feed?limit=20" \
  -H "x-messari-api-key: $MESSARI_API_KEY"
```

## Routing Guidance

### General crypto questions
Route through **AI** first — broadest context, synthesizes across market data, research, news, social.

### Quantitative questions
Use **Metrics** for price/volume/fundamentals. **Exchanges** for exchange-level data. **Networks** for L1/L2 metrics. **Protocols** for DeFi-specific data.

### Sentiment and narratives
**Signal** for mindshare and sentiment. **Topics** for trending narrative classes. **X-Users** for influencer-level metrics.

### Specific asset classes
**Stablecoins** for stablecoin supply and flows. **Token Unlocks** for vesting schedules and upcoming unlocks.

### Research, news, and events
**Research** for deep dives and reports. **News** for real-time events. **Intel** for governance and protocol updates. **Fundraising** for funding rounds and M&A.

### Multi-service queries
Combine services for richer answers. Example — "Is SOL overvalued?":
1. **Metrics** → current price, volume, fundamentals
2. **Signal** → sentiment and mindshare trend
3. **Token Unlocks** → upcoming supply pressure
4. **AI** → synthesize a view from all data
