# Tone and Context Matching

## The Fundamental Rule
The SAME person may require different tones on different platforms:
- Professional on email/LinkedIn
- Casual on Discord/Telegram
- Brief on Twitter
- Warm on WhatsApp

Check message history before assuming.

## Tone Spectrum

### Formal (Email to clients/investors, LinkedIn)
- Full sentences, proper grammar
- Professional greeting: "Hi María,"
- Clear structure: context → ask → close
- Signature with title
- No emojis or minimal (🙂 max)

### Semi-Formal (Slack to colleagues, professional Discord)
- Complete sentences, relaxed grammar
- Quick greeting or none: "Hey," or straight to point
- Some emojis okay (👍, ✅)
- Thread-appropriate casual

### Casual (Friend groups, gaming Discord, personal Telegram)
- Fragments okay, lowercase
- Emojis and reactions expected
- Inside jokes and memes
- Brevity: "lol k" is valid

## Context That Changes Everything

### Recent Events
- Don't be chipper after company layoffs
- Acknowledge outages before marketing
- Match community sentiment

### Relationship History
- First message: slightly formal
- 50th message: match established pattern
- Post-conflict: measured, not overly warm

### Time of Day
- Morning: slightly more formal
- Late night: brief, casual
- Depends on relationship

## User Style Matching

### What to Copy
- Length of typical messages
- Emoji usage patterns (or lack thereof)
- Greeting/closing style (or none)
- Response cadence (fast replier vs takes hours)

### What NOT to Do
- Add phrases they never use
- Use emojis they avoid
- Be MORE responsive than they are
- Sign texts with their name (nobody does this)

## Relationship Types

### Investors/Board
- Always formal
- Draft for review
- Never auto-send
- Precise language

### Clients (Enterprise)
- Professional
- Clear, no jargon
- Documented communication

### Clients (Startup-to-startup)
- Often casual
- Check history first
- Match their energy

### Team
- Match team culture
- Can be casual
- Thread appropriately

### Friends/Family
- Casual to very casual
- Inside jokes okay
- Voice notes may be expected

## Red Flags to Match Tone
If they use:
- "Dear [Name]" → formal response required
- "lol" / "bruh" → casual okay
- Full punctuation → match formality
- Emojis → reciprocate appropriately
- No greeting → skip greeting in reply
