# Platform-Specific Formatting

## Telegram
- **Markdown support:** Bold, italic, code, code blocks, links
- **NO tables:** Markdown tables render as broken text
- **Edits visible:** Edit history shows — avoid multiple corrections
- **Silent messages:** Use for non-urgent late-night sends
- **Character limit:** 4096 per message
- **Pinned messages:** Prime real estate, don't overuse

## WhatsApp
- **Basic formatting:** `*bold*`, `_italic_`, `~strikethrough~`, monospace
- **NO markdown links:** `[text](url)` doesn't work
- **Voice notes:** Intimate — never send AI-generated audio pretending to be user
- **Read receipts:** Blue ticks mean they KNOW you've seen it
- **Reactions:** Casual, low-stakes
- **Media compression:** Images lose quality

## Slack
- **Rich formatting:** Full markdown, code blocks, blockquotes
- **Threads mandatory:** Reply in thread, not channel
- **@here vs @channel:** @channel notifies everyone including offline
- **Emoji reactions:** Part of culture, use appropriately
- **Workflows:** Can trigger automations
- **Channel purposes:** Match tone to channel (#random ≠ #engineering)

## Discord
- **Full markdown:** Headers, lists, code, embeds
- **Threads:** Use for extended discussions
- **@everyone/@here:** Triggers everyone — use sparingly
- **Channels have context:** #announcements ≠ #memes
- **Bot perception:** Being too formal reads as corporate/fake

## Email
- **Subject lines:** Critical for open rates, be specific
- **Plain text:** Often better than HTML
- **Signatures:** Required for external, optional internal
- **Reply-all:** Think before clicking
- **Threading:** RE: vs new thread matters
- **Formal opening/closing:** Match relationship

## iMessage
- **Tapbacks:** Liked vs Loved carries social weight
- **Typing indicators:** They see when you're typing
- **Reactions to wrong message:** Awkward, can't easily fix
- **Read receipts:** Optional but revealing

## Twitter/X
- **280 characters:** Punchy, not paragraphs
- **Threads:** For longer content
- **Quote tweets:** For engagement
- **Don't look like a bot:** Vary phrasing

## Cross-Platform Rules
- Same message verbatim across platforms = obvious automation
- Each platform's audience may overlap — don't spam
- Formatting that works on one platform breaks on another
- Test before assuming
