# Mermaid Diagrams

Create professional software diagrams using Mermaid's text-based syntax. Mermaid renders diagrams from simple text definitions, making diagrams version-controllable, easy to update, and maintainable alongside code.

## What's Inside

- Core syntax and diagram type selection guide
- Quick start examples for Class, Sequence, Flowchart, and ERD diagrams
- Diagram type references: Class, Sequence, Flowcharts, ERD, C4 Architecture, State, Git Graphs, Gantt Charts
- Configuration and theming (themes, layout engines, hand-drawn look)
- Rendering support (GitHub, VS Code, Notion, Obsidian, Confluence)
- Export options (Mermaid Live Editor, CLI)
- Best practices and common pitfalls
- Detailed reference files for each diagram type and advanced features

## When to Use

- Creating, visualizing, or documenting software through diagrams
- Class diagrams, sequence diagrams, flowcharts, ERDs, C4 architecture diagrams
- State diagrams, git graphs, and other diagram types
- Triggered by requests to: diagram, visualize, model, map out, or show the flow of a system

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/writing/mermaid-diagrams
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install mermaid-diagrams
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/writing/mermaid-diagrams .cursor/skills/mermaid-diagrams
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/writing/mermaid-diagrams ~/.cursor/skills/mermaid-diagrams
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/writing/mermaid-diagrams .claude/skills/mermaid-diagrams
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/writing/mermaid-diagrams ~/.claude/skills/mermaid-diagrams
```

## Related Skills

- **clear-writing** — Pair diagrams with prose documentation
- **article-illustrator** — For non-technical visual illustrations

---

Part of the [Writing](..) skill category.
