---
name: mens-mental-health
description: Mental health support for men with emotion check-ins, stress tools, and no-judgment space
author: clawd-team
version: 1.0.0
triggers:
  - "mens mental health"
  - "feeling down as a man"
  - "need to talk"
  - "stress as a guy"
  - "men's emotions"
---

# Men's Mental Health

A no-judgment space where you can check in with yourself, work through stress, and build resilience without the noise.

## What it does

This skill gives you tools to:
- **Emotion Check-ins**: Name what you're feeling and understand it
- **Stress Management**: Practical techniques to decompress when things pile up
- **Healthy Coping**: Alternatives to harmful patterns that actually work
- **Pattern Tracking**: Spot what triggers stress and what helps you recover

## Usage

### Check In
Start here when you need clarity. Answer a few quick questions about your current state—mood, what triggered it, physical symptoms. The skill reflects back what it hears and offers perspective.

### Stress Tools
When pressure builds, access immediate techniques: breathing patterns, body scans, reframing tools, and grounding exercises. Designed for 2-10 minutes depending on urgency.

### Vent
Sometimes you need to get it out. Use this to process a situation without fixing it immediately. The skill listens, validates, and helps you organize your thoughts.

### Track Patterns
Over time, identify what consistently drains or energizes you. See correlations between sleep, work, relationships, and your mental state. Data stays local—only you see it.

### Get Perspective
When you're stuck in a loop, talk through it. The skill asks clarifying questions, offers reframes, and helps you see angles you might have missed.

## Common Topics

- **Work stress**: Pressure, powerlessness, toxic culture
- **Relationships**: Conflict, disconnection, communication breakdowns
- **Identity**: Masculinity, expectations, being "enough"
- **Anger**: Rage, irritability, control and letting loose
- **Isolation**: Loneliness, withdrawn, lack of connection
- **Purpose**: Direction, meaning, questioning your path

## Tips

1. **Be honest**. There's no judgment here. The more real you are, the more useful the reflection.
2. **Use it regularly**, not just in crisis. Check-ins work best as a habit—weekly or when things shift.
3. **Combine with other tools**. A therapist, trusted friend, or doctor handles what a skill can't. Use this alongside, not instead of.
4. **Notice patterns over time**. One conversation is helpful. Tracking months of data shows you what actually moves the needle.
5. **All data stays local on your machine**. Nothing leaves your device without your explicit choice.

## If You're in Crisis

This skill is not a substitute for professional help.

- **988** (Suicide & Crisis Lifeline)
- **Text HOME to 741741** (Crisis Text Line)

If you're in immediate danger, call 911 or go to your nearest emergency room.
