# 记忆模板

## 模板格式

```markdown
## [ID] 记忆标题

- **类型**: preference|knowledge|relationship|task|skill
- **来源**: 对话/文档链接
- **日期**: YYYY-MM-DD
- **置信度**: high|medium|low
- **标签**: #标签 1 #标签 2
- **内容**: 
  详细描述...

- **关联**: [[其他记忆 ID]]
- **状态**: active|archived|completed (仅 task 类型需要)
```

## 类型说明

| 类型 | 用途 | 示例 |
|------|------|------|
| `preference` | 用户偏好、习惯、风格 | "喜欢极简设计"、"早上 9 点前不发消息" |
| `knowledge` | 领域知识、事实信息 | "项目技术栈说明"、"API 文档链接" |
| `relationship` | 人际关系、组织上下文 | "某人是项目负责人"、"某公司是合作伙伴" |
| `task` | 待办事项、项目 | "优化 UI 设计"、"研究某股票" |
| `skill` | 技能、方法、流程 | "如何复盘"、"技术分析步骤" |

## ID 命名规则

`<类型首字母>-<日期>-<序号>`
- `P-20260302-001` (Preference)
- `K-20260302-001` (Knowledge)
- `R-20260302-001` (Relationship)
- `T-20260302-001` (Task)
- `S-20260302-001` (Skill)

## 最佳实践

1. **原子化** - 每条记忆只包含一个独立事实
2. **可检索** - 标签要具体，便于搜索
3. **可关联** - 相关记忆互相链接
4. **有时效** - 任务类记忆要更新状态
