# Memphis Commands Reference

## Core

```bash
memphis init                          # initialize ~/.memphis (first run)
memphis status [--json --verbose]     # chains, providers, daemon health
memphis journal "<text>" [options]    # append to journal chain
  --tags <t1,t2>                      # add tags
  --chain <name>                      # default: journal
  --force                             # trigger autosummary

memphis recall <keyword> [query]      # search memory
  --chain <name>                      # filter by chain
  --tag <tag>                         # filter by tag
  --since <7d|2026-01-01>             # time window
  --limit <n>                         # max results
  --json                              # JSON output

memphis ask "<question>"              # LLM answer with memory context
  --provider <ollama|codex|openai>
  --model <name>
  --no-save                           # don't save to ask chain
  --graph                             # include graph context (default: true)
```

## Cognitive layer

```bash
memphis embed [--chain <name>]        # generate embeddings (run daily)
memphis graph build [--dry-run]       # build knowledge graph
memphis graph show [nodeId]           # explore graph
  --chain <name>
  --tag <tag>
  --stats

memphis reflect [--daily|--weekly|--deep]  # reflection report
  --save                              # save to journal
  --json

memphis ingest <path>                 # import files into memory
  --recursive                         # recurse dirs
  --embed                             # also embed
  --dry-run                           # preview only
  --tags <t1,t2>

memphis watch [path]                  # auto-ingest on file change
  --no-embed
  --chain <name>
```

## Decisions

```bash
memphis recall decision               # list all decisions
memphis revise <decisionId> --reason "<why>" [--status revised]
```

## Daemon

```bash
memphis daemon start                  # start background daemon
memphis daemon stop
memphis daemon status
memphis daemon logs                   # tail log
memphis daemon restart
```

## Share & Sync

```bash
memphis share-sync --push             # push share-tagged blocks to Pinata
memphis share-sync --pull             # pull from network chain
memphis share-sync --all --push-disabled   # read-only nodes
memphis share plan                    # dry-run diff
```

## Self-coding loop

```bash
memphis ingest src/                   # Memphis reads its own code
memphis graph build                   # build module relationships
memphis plan --focus <file.ts>        # generate Codex task from memory
memphis plan --focus <file.ts> --exec # auto-launch codex
```
