---
name: memphis
description: Memphis AI brain integration — automatically journal decisions, insights, code changes, and user context to local memory chains via CLI. Use when: (1) user makes a decision or shares a preference → save it, (2) completing a task → journal what was done, (3) user asks to remember something → save to Memphis, (4) user asks what was decided/done before → recall from Memphis, (5) any significant event during the session worth persisting. Memphis CLI must be installed (npm run build in ~/memphis). If Memphis is not installed or a required value is missing, ask the user before saving.
---

# Memphis Brain Skill

Memphis is a local-first AI memory system. OpenClaw uses it to persist decisions, insights, and context across sessions.

## Core Principle

**Save first, ask only when blocked.** If you have enough context → journal immediately. If a required piece of data is missing and you cannot infer it → ask the user one focused question, then save.

## When to save automatically (no asking needed)

- User makes a decision → `memphis journal "Postanawiam: ..." --tags decyzja`
- Task completed → `memphis journal "Zrobione: [co] [jak] [wynik]" --tags done`
- User shares a preference → `memphis journal "Preferencja: ..." --tags preferencja`
- Error solved → `memphis journal "Problem: ... Rozwiązanie: ..." --tags bug,fix`
- Insight discovered → `memphis journal "Insight: ..." --tags insight`
- Code refactored → `memphis journal "Refaktor: [plik] — [co zmieniono] [dlaczego]" --tags code,refactor`
- Session end → `memphis journal "EOD: [co zrobiono] [co następne]" --tags eod,summary`

## When to ask before saving

Ask **one specific question** if:
- The decision lacks a subject ("Postanawiam to zrobić" — co zrobić?)
- The tag context is ambiguous and matters for recall
- User says "zapamiętaj to" but "to" is unclear

Never ask multiple questions at once. Pick the most important missing piece.

## Commands

```bash
# Save a journal entry
memphis journal "<text>" --tags <tag1,tag2>

# Recall from memory (keyword + semantic)
memphis recall "<keyword>" [--chain journal] [--since 7d] [--tag decyzja]

# Ask Memphis with full context
memphis ask "<question>" [--provider ollama]

# Weekly reflection
memphis reflect --weekly

# Check status
memphis status
```

## Tag conventions

| Tag | When to use |
|-----|-------------|
| `decyzja` | Any decision made |
| `preferencja` | User preference or style |
| `done` | Completed task |
| `bug,fix` | Problem + solution |
| `insight` | Non-obvious learning |
| `code,refactor` | Code change |
| `eod,summary` | End of session |
| `cel,focus` | Goal or intention |

## Recall before answering

When user asks about past decisions, preferences, or context → **always recall first**:

```bash
memphis recall "<keyword>" --since 30d
```

Then use the result as context in your answer.

## Missing data examples

| Situation | What to ask |
|-----------|-------------|
| "zapamiętaj to" (unclear what) | "Co dokładnie zapamiętać? Podaj krótki opis." |
| Decision without context | "Jaki jest powód tej decyzji? (opcjonalnie — mogę zapisać bez powodu)" |
| Tag unknown | Skip asking — use `misc` tag |

## Full commands reference

See `references/commands.md` for all Memphis commands with flags.
