---
name: Memphis Cognitive Engine
version: "2.0.1"
description: Decision-first AI memory - cognitive engine for humans
author: Elathoxu Abbylan
tags: [cognitive, decisions, ai, memory, agent, local-first, polska]
category: productivity
license: MIT
repository: https://github.com/elathoxu-crypto/memphis
documentation: https://github.com/elathoxu-crypto/memphis/docs
---

# Memphis Cognitive Engine

**Memphis = Agent + LLM + Memory Chain + DECIDE**

## 📚 Dokumentacja

**Pełna dokumentacja projektu:** [MEMORY.md](file:///home/memphis/.openclaw/workspace/MEMORY.md)

**Oficjalna wizja:** [VISION.md](file:///home/memphis/memphis/docs/VISION.md)

**Decision Schema:** [DECISION_SCHEMA.md](file:///home/memphis/memphis/docs/DECISION_SCHEMA.md)

**Implementation Roadmap:** [VISION-IMPLEMENTATION-ROADMAP.md](file:///home/memphis/memphis/docs/VISION-IMPLEMENTATION-ROADMAP.md)

---

## 📦 Changelog

### v2.0.1 (2026-03-02 13:25 CET)
- ✅ **FIX:** Added `-t, --tags` option to CLI (bug found in testing)
- ✅ Updated documentation to match CLI options
- ✅ Test confirmed: tags now work in `memphis decide`

### v2.0.0 (2026-03-02 12:16 CET)
- 🎉 **INITIAL RELEASE** to ClawHub
- ✅ 35+ commands exposed
- ✅ Decision-first memory system
- ✅ Polish language support
- ✅ 90.7% intelligence accuracy
- ✅ Based on VISION.md + DECISION_SCHEMA.md

---

## 🎯 Filozofia

**DECISION-FIRST MEMORY**

Memphis to nie notatnik. To **cognitive engine** - system poznawczy, który:
- Pamięta Twoje decyzje (dlaczego wybrałeś X?)
- Śledzi ich lifecycle (active → revised → reinforced)
- Wykrywa nowe decyzje (agent inference)
- Generuje insights (LLM reflection)

**Dla kogo:**
- Developer-business ownerów
- Przedsiębiorców w Polsce
- Każdego kto podejmuje 100+ decyzji dziennie

---

## 🏗️ Architektura

### 4 Warstwy (zgodnie z VISION.md):

```
┌─────────────────────────────────────────┐
│  Layer 4: Interface (CLI/TUI/IDE)       │
├─────────────────────────────────────────┤
│  Layer 3: Offline LLM (Ollama/Local)    │
├─────────────────────────────────────────┤
│  Layer 2: Agent Runtime (Daemon/Watch)  │
├─────────────────────────────────────────┤
│  Layer 1: Memory Ledger (Blockchain)    │
└─────────────────────────────────────────┘
```

**Status (v1.7.6):**
- ✅ Layer 1: Memory Ledger (COMPLETE)
- 🚧 Layer 2: Agent Runtime (70% - daemon, collectors, inference pending)
- ✅ Layer 3: Offline LLM (COMPLETE)
- 🚧 Layer 4: Interface (80% - CLI/TUI done, frictionless capture pending)

---

## 🚀 Komendy

### CORE: Decyzje (PRIMARY)

#### /memphis decide <title> <chosen> [options]
Zapisz decyzję do chaina.

**Syntax:**
```bash
/memphis decide "Tytuł decyzji" "Wybór" -r "Powód" -o "Opcja A" -o "Opcja B"
```

**Options:**
- `-r, --reasoning <text>` - Dlaczego ten wybór
- `-o, --option <text>` - Rozważane opcje (wiele)
- `-s, --scope <personal|project|life>` - Zakres wpływu
- `-c, --confidence <0-1>` - Pewność (conscious=1.0)
- `-t, --tags <tags>` - Tagi (comma-separated)

**Przykłady:**
```bash
# Minimal:
/memphis decide "Używam TypeScript" "TypeScript"

# Pełny:
/memphis decide "Memphis idzie w personal brain" "Personal brain" \
  -r "Krótszy path to value" \
  -o "Personal brain" \
  -o "Infra dla agentów" \
  -s project \
  -t strategic,direction
```

#### /memphis decisions [filter]
Listuj decyzje z filtrami.

**Filters:**
- `--status <active|revised|deprecated>` - Status
- `--mode <conscious|inferred>` - Tryb
- `--scope <personal|project|life>` - Zakres
- `--tags <tags>` - Tagi
- `--recent <n>` - Ostatnie N dni
- `--limit <n>` - Limit wyników

**Przykłady:**
```bash
/memphis decisions                    # Wszystkie aktywne
/memphis decisions --recent 7         # Ostatnie 7 dni
/memphis decisions --tags strategic   # Strategiczne
```

#### /memphis revise <decision-id> <new-choice>
Zaktualizuj decyzję.

**Effect:**
- Stara decyzja → status: `deprecated`
- Nowa decyzja → status: `active`, `parent_id` = stara

**Przykład:**
```bash
/memphis revise dec_01JVX... "Używam MongoDB" -r "Elastyczność ważniejsza"
```

#### /memphis reflect [options]
LLM-powered reflection.

**Modes:**
- `--daily` - Last 24h
- `--weekly` - Last 7d (default)
- `--deep` - Last 30d
- `--save` - Save to journal

**Przykład:**
```bash
/memphis reflect --weekly --save
→ Analiza decyzji, wzorców, insights
```

---

### MEMORY: Tradycyjna pamięć (SECONDARY)

#### /memphis journal <text> [--tags tags]
Zapisz event do journal chain.

**Przykład:**
```bash
/memphis journal "Fixed bug in TUI" --tags code,bugfix
```

#### /memphis ask <question>
Zapytaj Memphis z kontekstem.

**Przykład:**
```bash
/memphis ask "Dlaczego wybrałem Node.js dla ABC?"
→ Znajduje decyzje + kontekst
```

#### /memphis recall <keywords>
Semantic search.

**Przykład:**
```bash
/memphis recall "baza danych wybór"
→ Decyzje, journal, reflections
```

---

### ADVANCED: Hidden Features (EXPOSE!)

#### /memphis plan [options]
Wygeneruj coding task z pamięci → codex exec!

**Features:**
- Memory → task generation
- Auto-exec z codex
- Focus option

**Przykład:**
```bash
/memphis plan --exec --yolo
→ Generuje task z Twoich decyzji i puszcza codex!
```

**To jest KILLER FEATURE!** Memory → Code automatycznie!

#### /memphis intelligence [action]
Phase 6 Intelligence - learning system!

**Actions:**
- `stats` - Learning statistics (90.7% accuracy!)
- `clear` - Reset learning data

**Features:**
- Auto-categorization (77.2% accuracy)
- 366 regex patterns
- Time-based suggestions
- 54 feedback events

**Przykład:**
```bash
/memphis intelligence stats
→ Shows learning metrics, top tags, accuracy
```

#### /memphis daemon [command]
Background daemon - passive memory collection!

**Commands:**
- `start` - Start daemon
- `stop` - Stop daemon
- `status` - Check status
- `logs` - Tail logs

**Features:**
- Git collector (auto-ingest commits)
- Shell collector (command history)
- Auto-reflection
- Event detection

**Przykład:**
```bash
/memphis daemon start
→ Agent działa w tle, zbiera events, proponuje decisions
```

#### /memphis graph [command]
Knowledge graph visualization!

**Commands:**
- `build` - Build graph from chains
- `show` - Show nodes/edges

**Features:**
- Node extraction
- Edge creation
- Cluster detection

#### /memphis trade [command]
Multi-agent network - trade protocol!

**Commands:**
- `create <did>` - Create trade offer
- `accept <manifest>` - Accept trade
- `list` - Pending offers
- `verify <manifest>` - Verify signature

**Features:**
- DID-based identity
- Signed manifests
- Block trading

#### /memphis mcp [command]
MCP Server - expose Memphis to other tools!

**Commands:**
- `start` - Start MCP server (stdio)
- `inspect` - Show available tools

**Features:**
- Model Context Protocol
- Tool exposure
- Integration ready

---

### UTILITY

#### /memphis status
Show Memphis health and stats.

**Output:**
- Chains: blocks count
- Providers: status
- Embeddings: coverage
- Recent: last 5 entries

#### /memphis dashboard
Custom dashboard (OpenClaw-specific).

**Shows:**
- Status + recent activities
- Active decisions
- Pending tasks
- Insights summary

#### /memphis help
Show all 35+ commands.

---

## 🧠 Decision Schema

Wszystkie decyzje zgodne z [DECISION_SCHEMA.md](file:///home/memphis/memphis/docs/DECISION_SCHEMA.md):

```typescript
interface DecisionBlock {
  // Required
  id: string;
  timestamp: string;
  mode: "conscious" | "inferred";
  title: string;
  chosen: string;
  impact_scope: "personal" | "project" | "life";
  
  // Optional
  context?: string;
  options?: string[];
  reasoning?: string;
  confidence?: number;  // conscious=1.0, inferred<0.85
  evidence_links?: string[];
  parent_id?: string;
  status?: "active" | "revised" | "deprecated" | "contradicted" | "reinforced";
  tags?: string[];
  source?: "user" | "agent";
  
  // Auto-filled
  projectPath?: string;
  gitRoot?: string;
  hostname?: string;
}
```

---

## 🔄 Decision Lifecycle

Decyzje ewoluują:

```
active (initial)
    │
    ├── revised → zaktualizowana
    ├── contradicted → obalona
    ├── deprecated → nieaktualna
    └── reinforced → potwierdzona
```

**Przykład timeline:**

**Dzień 1:**
```
/memphis decide "Używam PostgreSQL dla projektu X"
→ Status: active
```

**Dzień 30:**
```
/memphis revise <id> "Przeszłem na MongoDB dla elastyczności"
→ Stara: deprecated, Nowa: active (z parent_id)
```

**Dzień 60:**
```
/memphis reflect
→ "Decyzja o MongoDB była słuszna - elastyczność się opłaciła"
→ Stara decyzja: reinforced
```

---

## 🤖 Two Types of Decisions

### 1. Conscious Decisions (Manual)

Ty wyraźnie mówisz Memphis:

```bash
/memphis decide "Używam Node.js dla ABC" -r "Szybszy development"
```

- Mode: `conscious`
- Confidence: 1.0
- Source: user

### 2. Inferred Decisions (Agent)

Agent wykrywa wzorce i pyta:

```bash
# Agent: "Zauważyłem że usunąłeś branch 'mvp-pivot'"
# "Czy zdecydowałeś zmienić strategię?"
/memphis detect confirm
```

- Mode: `inferred`
- Confidence: 0.0-0.85
- Source: agent
- Wymaga Twojego potwierdzenia

---

## 🔍 Auto-Detection Rules

### Conscious Keywords (user triggers):
```
decide, chose, selected, picked, decision, 
wybieram, zdecydowano, zdecydowałem, postanowiłem
```

### Inferred Patterns (agent detects):
```
- Branch deleted + new commit pattern
- File renamed/moved (refactoring signal)
- Config changed (architecture shift)
- Repeated command patterns
```

---

## 📊 Use Cases

### DLA DEVELOPER-BUSINESS OWNERA:

#### 1. 👥 CRM Inteligentny
```bash
/memphis decide "Akceptuję klienta ABC" "Akceptuję" \
  -r "Budżet 50k PLN, deadline marzec, e-commerce" \
  -s project \
  -t client,sales,abc

# Miesiąc później:
/memphis ask "Co wiem o kliencie ABC?"
→ Memphis pokazuje: decyzja, reasoning, kontekst
```

#### 2. 📋 Zarządzanie Projektami
```bash
/memphis decide "Zmiana technologii z PHP na Node.js" "Node.js" \
  -r "Wydajność, real-time features" \
  -s project \
  -t tech,migration

# Później:
/memphis recall "technologia projekt"
→ Memphis: "Zmieniono z PHP na Node.js dla wydajności..."
```

#### 3. 💰 Finanse
```bash
/memphis decide "Inwestuję w serwer dedykowany" "Dedykowany" \
  -r "Koszt 500 PLN/mies, ROI 3 miesiące" \
  -s project \
  -t finance,infrastructure
```

#### 4. 🤝 Spotkania
```bash
/memphis journal "Spotkanie z zespołem: sprint 2 tyg, priority: auth, blocker: design" \
  --tags meeting,team,sprint

/memphis reflect --weekly --save
→ Insights z całego tygodnia
```

---

## 🔧 Integracje

### Z OpenClaw:
- Auto-detect decisions w chat
- `/memphis` commands from OpenClaw
- Context injection z decision chains

### Z Git:
- Auto-detect inferred decisions z commits
- Link decisions → commits (evidence)
- Branch analysis

### Z IDE (future):
- Inline decision prompts
- Code context → decision suggestions
- Real-time reflection

---

## ⚙️ Konfiguracja

Memphis czyta z `~/.memphis/config.yaml`:

```yaml
decisions:
  auto_detect: true
  inference_confidence_threshold: 0.5
  
agent:
  watch_terminal: true
  watch_git: true
  watch_files: false
  
reflection:
  schedule: "daily"
  model: "ollama/qwen2.5-coder"
  
chains:
  decisions: "~/.memphis/decisions/decisions.jsonl"
  journal: "~/.memphis/chains/journal.jsonl"
  reflections: "~/.memphis/chains/reflections.jsonl"
```

---

## 🎯 Value Proposition

### Dla Przedsiębiorcy (Ty!):
✅ Nigdy nie zapomnij dlaczego podjąłeś decyzję
✅ Śledź lifecycle (active → revised → reinforced)
✅ Agent wykrywa nowe decyzje za Ciebie
✅ LLM-powered reflection (insights)
✅ Multi-domain (code + business + personal)

### ROI:
- Czas zaoszczędzony na szukaniu: 1-2h/tydzień
- Lepsze decyzje (historyczny kontekst)
- Pattern awareness (uczy się na błędach)
- Cognitive load reduction

---

## 🔒 Security & Privacy

- **Local-first:** Wszystko na Twoim kompie
- **No cloud:** Zero zależności od chmury
- **Encrypted:** Opcjonalne szyfrowanie chainów
- **GDPR compliant:** Twoje dane = Twoja własność
- **No telemetry:** Zero trackingu

---

## 📦 Installation

```bash
# Z ClawHub
clawhub install memphis-cognitive-engine

# Manualnie
git clone https://github.com/elathoxu-crypto/memphis-skill
cd memphis-skill
clawhub install .
```

---

## ✅ Requirements

- **Memphis CLI v1.7.6+** (`npm install -g @elathoxu-crypto/memphis`)
- **OpenClaw** running
- **Ollama** lub inny LLM provider
- **Node.js 18+**
- **Git** (dla agent features)

---

## 📚 Dokumentacja Projektu

**Główne:**
- [MEMORY.md](file:///home/memphis/.openclaw/workspace/MEMORY.md) - Long-term memory (ten plik!)
- [VISION.md](file:///home/memphis/memphis/docs/VISION.md) - Oficjalna wizja
- [DECISION_SCHEMA.md](file:///home/memphis/memphis/docs/DECISION_SCHEMA.md) - Schema decyzji

**Roadmaps:**
- [VISION-IMPLEMENTATION-ROADMAP.md](file:///home/memphis/memphis/docs/VISION-IMPLEMENTATION-ROADMAP.md) - Implementation
- [PHASE-6-INTELLIGENCE-ROADMAP.md](file:///home/memphis/memphis/docs/PHASE-6-INTELLIGENCE-ROADMAP.md) - Intelligence

**Guides:**
- [QUICKSTART.md](file:///home/memphis/memphis/docs/QUICKSTART.md) - 5-minute start
- [TUI-FEATURES.md](file:///home/memphis/memphis/docs/TUI-FEATURES.md) - TUI guide

---

## 🚀 Roadmap

### v2.1.0 (Current - Etap 2+3)
- [x] Decision schema ✅
- [ ] Agent runtime (daemon done, inference pending)
- [ ] Inferred decision detection
- [ ] LLM reflection (done!)

### v2.2.0
- [ ] IDE integration
- [ ] Advanced patterns
- [ ] Decision analytics dashboard

### v3.0.0
- [ ] Multi-user chains (team decisions)
- [ ] Predictive insights
- [ ] Voice commands

---

## 💡 Examples

### Scenariusz: Project Direction

**Dzień 1:**
```bash
/memphis decide "Memphis idzie w personal brain" "Personal brain" \
  -r "Krótszy path to value" \
  -o "Personal brain" \
  -o "Infra for agents"
```

**Dzień 30:**
```bash
/memphis revise <id> "Dodaję też agent features" \
  -r "Users want both"
```

**Dzień 60:**
```bash
/memphis reflect
→ "Original decision correct - personal brain is core value. Agent features complement it."
```

### Scenariusz: Technology Choice

**Dzień 1:**
```bash
/memphis decide "Używam Node.js dla klienta ABC" "Node.js" \
  -r "Team expertise, fast development" \
  -s project \
  -t tech,client
```

**Dzień 15:**
```bash
/memphis ask "Dlaczego Node.js dla ABC?"
→ Memphis: decision, reasoning, context
```

**Dzień 60:**
```bash
/memphis insights
→ "Technical decisions revised within 2 weeks: 30%"
→ "Node.js decisions reinforced: 90%"
```

---

## 🇵🇱 Polish Language Support

Memphis wspiera polskie keywords:
- `zdecydowałem, postanowiłem, wybrałem, zdecydowano`
- `klient, faktura, spotkanie, budżet, umowa, sprzedaż`
- `decyzja, wybór, ustalenie`

Auto-categorization działa dla PL i EN!

---

**Created by:** Elathoxu Abbylan (Memphis)  
**License:** MIT  
**Support:** https://discord.gg/clawd  
**Documentation:** [MEMORY.md](file:///home/memphis/.openclaw/workspace/MEMORY.md)
